/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.aes.AesScaling;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgLineElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgRectElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/util/BoxLegendKeyElementFactory;", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "whiskers", "", "(Z)V", "getWhiskers", "()Z", "createKeyElement", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "size", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "plot-base"})
final class BoxLegendKeyElementFactory
implements LegendKeyElementFactory {
    private final boolean whiskers;

    public BoxLegendKeyElementFactory(boolean whiskers) {
        this.whiskers = whiskers;
    }

    public final boolean getWhiskers() {
        return this.whiskers;
    }

    @Override
    @NotNull
    public SvgGElement createKeyElement(@NotNull DataPointAesthetics p, @NotNull DoubleVector size) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        double whiskerSize = 0.2;
        double strokeWidth = AesScaling.INSTANCE.strokeWidth(p);
        double width2 = (size.getX() - strokeWidth) * 0.8;
        double height = size.getY() - strokeWidth;
        double x = (size.getX() - width2) / (double)2;
        double y = strokeWidth / (double)2;
        double boxHeight = height;
        double boxY = y;
        if (this.whiskers) {
            boxHeight = height * (1.0 - (double)2 * whiskerSize);
            boxY = y + height * whiskerSize;
        }
        SvgRectElement rect = new SvgRectElement(x, boxY, width2, boxHeight);
        GeomHelper.Companion.decorate$default(GeomHelper.Companion, (SvgNode)rect, p, false, null, 12, null);
        double middleY = y + height * 0.5;
        SvgLineElement middle = new SvgLineElement(x, middleY, x + width2, middleY);
        GeomHelper.Companion.decorate$default(GeomHelper.Companion, (SvgNode)middle, p, false, null, 12, null);
        SvgGElement g = new SvgGElement();
        g.children().add((Object)rect);
        g.children().add((Object)middle);
        if (this.whiskers) {
            double middleX = x + width2 * 0.5;
            SvgLineElement lowerWhisker = new SvgLineElement(middleX, y + height * (1.0 - whiskerSize), middleX, y + height);
            GeomHelper.Companion.decorate$default(GeomHelper.Companion, (SvgNode)lowerWhisker, p, false, null, 12, null);
            SvgLineElement upperWhisker = new SvgLineElement(middleX, y, middleX, y + height * whiskerSize);
            GeomHelper.Companion.decorate$default(GeomHelper.Companion, (SvgNode)upperWhisker, p, false, null, 12, null);
            g.children().add((Object)lowerWhisker);
            g.children().add((Object)upperWhisker);
        }
        return g;
    }

    @Override
    @NotNull
    public DoubleVector minimumKeySize(@NotNull DataPointAesthetics p) {
        return LegendKeyElementFactory.DefaultImpls.minimumKeySize(this, p);
    }
}

