/*
 * Decompiled with CFR 0.152.
 */
package org.pbjar.jxlayer.plaf.ext.transform;

import java.awt.RenderingHints;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import org.pbjar.jxlayer.plaf.ext.TransformUI;
import org.pbjar.jxlayer.plaf.ext.transform.DefaultTransformModel;
import org.pbjar.jxlayer.plaf.ext.transform.TransformModel;

public final class TransformUtils {
    private TransformUtils() {
    }

    public static JLayer<JComponent> createTransformJLayer(JComponent component) {
        return TransformUtils.createTransformJLayer(component, 1.0, null);
    }

    public static JLayer<JComponent> createTransformJLayer(JComponent component, double scale, Map<RenderingHints.Key, Object> hints) {
        DefaultTransformModel model = new DefaultTransformModel();
        model.setScale(scale);
        return TransformUtils.createTransformJLayer(component, model, hints);
    }

    public static JLayer<JComponent> createTransformJLayer(JComponent component, TransformModel model, Map<RenderingHints.Key, Object> hints) {
        TransformUI ui = new TransformUI(model);
        ui.setRenderingHints(hints);
        return new JLayer<JComponent>(component, ui);
    }

    public static JLayer<JComponent> createTransformJLayer(JComponent component, double scale) {
        return TransformUtils.createTransformJLayer(component, scale, null);
    }

    public static JLayer<JComponent> createTransformJLayer(JComponent component, TransformModel model) {
        return TransformUtils.createTransformJLayer(component, model, null);
    }

    public static JLayer<? extends JComponent> findTransformJLayer(JComponent aComponent) {
        JLayer layer = (JLayer)SwingUtilities.getAncestorOfClass(JLayer.class, aComponent);
        if (layer != null) {
            ComponentUI ui = layer.getUI();
            if (ui instanceof TransformUI) {
                return layer;
            }
            return TransformUtils.findTransformJLayer(layer);
        }
        return null;
    }
}

