/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import com.google.auto.service.AutoService;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import org.apache.jmeter.engine.TreeCloner;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.gui.action.Save;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;

@AutoService(value={Command.class})
public class UndoCommand
extends AbstractAction {
    private static final Set<String> commands = new HashSet<String>();

    @Override
    public void doAction(ActionEvent e) throws IllegalUserActionException {
        GuiPackage guiPackage = GuiPackage.getInstance();
        String command = e.getActionCommand();
        if (command.equals("undo")) {
            guiPackage.undo();
        } else if (command.equals("redo")) {
            guiPackage.redo();
        } else {
            throw new IllegalArgumentException("Wrong action called: " + command);
        }
    }

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    public static HashTree convertAndCloneSubTree(HashTree tree) {
        Save executor = new Save();
        executor.convertSubTree(tree);
        TreeCloner cloner = new TreeCloner(false);
        tree.traverse((HashTreeTraverser)cloner);
        return cloner.getClonedTree();
    }

    static {
        commands.add("undo");
        commands.add("redo");
    }
}

