/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.io.Serializable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.BeanShellInterpreter;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.util.JMeterException;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BeanShellTestElement
extends AbstractTestElement
implements Serializable,
Cloneable,
ThreadListener,
TestStateListener {
    private static final Logger log = LoggerFactory.getLogger(BeanShellTestElement.class);
    private static final long serialVersionUID = 4L;
    private String parameters;
    private String filename;
    private String script;
    private boolean resetInterpreter = false;
    private transient BeanShellInterpreter bshInterpreter = null;
    private transient boolean hasInitFile = false;

    protected BeanShellTestElement() {
        this.init();
    }

    protected abstract String getInitFileProperty();

    protected BeanShellInterpreter getBeanShellInterpreter() {
        if (this.isResetInterpreter()) {
            try {
                this.bshInterpreter.reset();
            }
            catch (ClassNotFoundException e) {
                log.error("Cannot reset BeanShell: {}", (Object)e.toString());
            }
        }
        JMeterContext jmctx = JMeterContextService.getContext();
        JMeterVariables vars = jmctx.getVariables();
        try {
            this.bshInterpreter.set("ctx", jmctx);
            this.bshInterpreter.set("Label", this.getName());
            this.bshInterpreter.set("prev", jmctx.getPreviousResult());
            this.bshInterpreter.set("props", JMeterUtils.getJMeterProperties());
            this.bshInterpreter.set("vars", vars);
        }
        catch (JMeterException e) {
            log.warn("Problem setting one or more BeanShell variables {}", (Object)e.toString());
        }
        return this.bshInterpreter;
    }

    private void init() {
        this.parameters = "";
        this.filename = "";
        this.script = "";
        try {
            String initFileName = JMeterUtils.getProperty(this.getInitFileProperty());
            this.hasInitFile = initFileName != null;
            this.bshInterpreter = new BeanShellInterpreter(initFileName, log);
        }
        catch (ClassNotFoundException e) {
            log.error("Cannot find BeanShell: {}", (Object)e.toString());
        }
    }

    protected Object readResolve() {
        this.init();
        return this;
    }

    @Override
    public Object clone() {
        BeanShellTestElement o = (BeanShellTestElement)super.clone();
        o.init();
        return o;
    }

    protected Object processFileOrScript(BeanShellInterpreter bsh) throws JMeterException {
        return this.processFileOrScript(bsh, null);
    }

    protected Object processFileOrScript(BeanShellInterpreter bsh, SampleResult sampleResult) throws JMeterException {
        String fileName = this.getFilename();
        String params = this.getParameters();
        bsh.set("FileName", fileName);
        bsh.set("Parameters", params);
        bsh.set("bsh.args", JOrphanUtils.split((String)params, (String)" "));
        if (fileName.length() == 0) {
            String bshScript = this.getScript();
            if (sampleResult != null) {
                sampleResult.setSamplerData(bshScript);
            }
            return bsh.eval(bshScript);
        }
        if (sampleResult != null) {
            sampleResult.setSamplerData(fileName);
        }
        return bsh.source(fileName);
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String s) {
        this.script = s;
    }

    @Override
    public void threadStarted() {
        this.tryEvalNoLog("threadStarted()");
    }

    @Override
    public void threadFinished() {
        this.tryEvalNoLog("threadFinished()");
    }

    @Override
    public void testEnded() {
        this.tryEvalNoLog("testEnded()");
    }

    @Override
    public void testEnded(String host) {
        this.tryEval("testEnded(\"" + host + "\")");
    }

    @Override
    public void testStarted() {
        this.tryEvalNoLog("testStarted()");
    }

    @Override
    public void testStarted(String host) {
        this.tryEval("testStarted(\"" + host + "\")");
    }

    private void tryEval(String code) {
        block3: {
            if (this.bshInterpreter == null || !this.hasInitFile) {
                return;
            }
            try {
                this.bshInterpreter.eval(code);
            }
            catch (JMeterException e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("{} : {}", (Object)this.getClass().getName(), (Object)e.getLocalizedMessage());
            }
        }
    }

    private void tryEvalNoLog(String code) {
        block3: {
            if (this.bshInterpreter == null || !this.hasInitFile) {
                return;
            }
            try {
                this.bshInterpreter.evalNoLog(code);
            }
            catch (JMeterException e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("{} : {}", (Object)this.getClass().getName(), (Object)e.getLocalizedMessage());
            }
        }
    }

    public String getParameters() {
        return this.parameters;
    }

    public void setParameters(String s) {
        this.parameters = s;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String s) {
        this.filename = s;
    }

    public boolean isResetInterpreter() {
        return this.resetInterpreter;
    }

    public void setResetInterpreter(boolean b) {
        this.resetInterpreter = b;
    }
}

