/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import org.apache.jmeter.samplers.SampleResult;

public class Calculator {
    private final DoubleAdder sum = new DoubleAdder();
    private final DoubleAdder sumOfSquares = new DoubleAdder();
    private final LongAdder count = new LongAdder();
    private final LongAdder bytes = new LongAdder();
    private final LongAdder sentBytes = new LongAdder();
    private final AtomicLong maximum = new AtomicLong();
    private final AtomicLong minimum = new AtomicLong();
    private final LongAdder errors = new LongAdder();
    private final String label;
    private final AtomicLong startTime = new AtomicLong();
    private final LongAccumulator elapsedTime = new LongAccumulator(Math::max, Long.MIN_VALUE);

    public Calculator() {
        this("");
    }

    public Calculator(String label) {
        this.label = label;
        this.clear();
    }

    public void clear() {
        this.maximum.set(Long.MIN_VALUE);
        this.minimum.set(Long.MAX_VALUE);
        this.sum.reset();
        this.sumOfSquares.reset();
        this.count.reset();
        this.bytes.reset();
        this.sentBytes.reset();
        this.errors.reset();
        this.startTime.set(Long.MAX_VALUE);
        this.elapsedTime.reset();
    }

    private void addValue(long newValue, int sampleCount) {
        long currentMaximum;
        double extraSumOfSquares;
        long value;
        this.count.add(sampleCount);
        this.sum.add(newValue);
        if (sampleCount > 1) {
            value = newValue / (long)sampleCount;
            extraSumOfSquares = (double)newValue * (double)newValue / (double)sampleCount;
        } else {
            value = newValue;
            extraSumOfSquares = (double)newValue * (double)newValue;
        }
        this.sumOfSquares.add(extraSumOfSquares);
        long currentMinimum = this.minimum.get();
        if (currentMinimum > value) {
            this.minimum.accumulateAndGet(value, Math::min);
        }
        if ((currentMaximum = this.maximum.get()) < value) {
            this.maximum.accumulateAndGet(value, Math::max);
        }
    }

    public void addSample(SampleResult res) {
        this.addBytes(res.getBytesAsLong());
        this.addSentBytes(res.getSentBytes());
        this.addValue(res.getTime(), res.getSampleCount());
        this.errors.add(res.getErrorCount());
        long testStarted = this.startTime.get();
        if (res.getStartTime() < testStarted) {
            testStarted = this.startTime.accumulateAndGet(res.getStartTime(), Math::min);
        }
        this.elapsedTime.accumulate(res.getEndTime() - testStarted);
    }

    public void addBytes(long newValue) {
        this.bytes.add(newValue);
    }

    private void addSentBytes(long value) {
        this.sentBytes.add(value);
    }

    public long getTotalBytes() {
        return this.bytes.sum();
    }

    public double getMean() {
        double sum = this.sum.sum();
        double count = this.count.sum();
        if (count == 0.0) {
            return 0.0;
        }
        return sum / count;
    }

    public Number getMeanAsNumber() {
        return (long)this.getMean();
    }

    public double getStandardDeviation() {
        double sum = this.sum.sum();
        double sumOfSquares = this.sumOfSquares.sum();
        double count = this.count.sum();
        if (count == 0.0) {
            return 0.0;
        }
        double mean = sum / count;
        return Math.sqrt(sumOfSquares / count - mean * mean);
    }

    public long getMin() {
        return this.minimum.get();
    }

    public long getMax() {
        return this.maximum.get();
    }

    public int getCount() {
        return (int)this.getCountLong();
    }

    public long getCountLong() {
        return this.count.sum();
    }

    public String getLabel() {
        return this.label;
    }

    public double getErrorPercentage() {
        long count = this.count.sum();
        if (count == 0L) {
            return 0.0;
        }
        return (double)this.errors.sum() / (double)count;
    }

    public double getRate() {
        return this.getRatePerSecond(this.count.sum());
    }

    public double getAvgPageBytes() {
        long count = this.count.sum();
        long bytes = this.bytes.sum();
        if (count > 0L && bytes > 0L) {
            return (double)bytes / (double)count;
        }
        return 0.0;
    }

    public double getBytesPerSecond() {
        return this.getRatePerSecond(this.bytes.sum());
    }

    public double getKBPerSecond() {
        return this.getBytesPerSecond() / 1024.0;
    }

    public double getSentBytesPerSecond() {
        return this.getRatePerSecond(this.sentBytes.sum());
    }

    public double getSentKBPerSecond() {
        return this.getSentBytesPerSecond() / 1024.0;
    }

    private double getRatePerSecond(long value) {
        long elapsedTime = this.elapsedTime.get();
        if (elapsedTime > 0L) {
            return (double)value / ((double)elapsedTime / 1000.0);
        }
        return 0.0;
    }
}

