/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.PropertiesBasedPrefixResolver;
import org.apache.jmeter.util.PropertiesBasedPrefixResolverForXpath2;
import org.apache.jmeter.util.TidyException;
import org.apache.jmeter.util.XPathQueryCacheLoader;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XPathUtil {
    private static final Logger log = LoggerFactory.getLogger(XPathUtil.class);
    private static final LoadingCache<ImmutablePair<String, String>, XPathExecutable> XPATH_CACHE;
    private static final Processor PROCESSOR;
    private static DocumentBuilderFactory documentBuilderFactory;

    private XPathUtil() {
    }

    public static Processor getProcessor() {
        return PROCESSOR;
    }

    private static synchronized DocumentBuilderFactory makeDocumentBuilderFactory(boolean validate, boolean whitespace, boolean namespace) throws ParserConfigurationException {
        if (documentBuilderFactory == null || documentBuilderFactory.isValidating() != validate || documentBuilderFactory.isNamespaceAware() != namespace || documentBuilderFactory.isIgnoringElementContentWhitespace() != whitespace) {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            documentBuilderFactory.setValidating(validate);
            documentBuilderFactory.setNamespaceAware(namespace);
            documentBuilderFactory.setIgnoringElementContentWhitespace(whitespace);
        }
        return documentBuilderFactory;
    }

    public static DocumentBuilder makeDocumentBuilder(boolean validate, boolean whitespace, boolean namespace, boolean downloadDTDs) throws ParserConfigurationException {
        DocumentBuilder builder = XPathUtil.makeDocumentBuilderFactory(validate, whitespace, namespace).newDocumentBuilder();
        builder.setErrorHandler(new MyErrorHandler(validate, false));
        if (!downloadDTDs) {
            EntityResolver er = (publicId, systemId) -> new InputSource(new ByteArrayInputStream(new byte[0]));
            builder.setEntityResolver(er);
        }
        return builder;
    }

    public static Document makeDocument(InputStream stream, boolean validate, boolean whitespace, boolean namespace, boolean tolerant, boolean quiet, boolean showWarnings, boolean reportErrors, boolean isXml, boolean downloadDTDs) throws ParserConfigurationException, SAXException, IOException, TidyException {
        return XPathUtil.makeDocument(stream, validate, whitespace, namespace, tolerant, quiet, showWarnings, reportErrors, isXml, downloadDTDs, null);
    }

    public static Document makeDocument(InputStream stream, boolean validate, boolean whitespace, boolean namespace, boolean tolerant, boolean quiet, boolean showWarnings, boolean report_errors, boolean isXml, boolean downloadDTDs, OutputStream tidyOut) throws ParserConfigurationException, SAXException, IOException, TidyException {
        Document doc = tolerant ? XPathUtil.tidyDoc(stream, quiet, showWarnings, report_errors, isXml, tidyOut) : XPathUtil.makeDocumentBuilder(validate, whitespace, namespace, downloadDTDs).parse(stream);
        return doc;
    }

    private static Document tidyDoc(InputStream stream, boolean quiet, boolean showWarnings, boolean report_errors, boolean isXML, OutputStream out) throws TidyException {
        StringWriter sw = new StringWriter();
        Tidy tidy = XPathUtil.makeTidyParser(quiet, showWarnings, isXML, sw);
        Document doc = tidy.parseDOM(stream, out);
        doc.normalize();
        if (tidy.getParseErrors() > 0) {
            if (report_errors) {
                log.error("TidyException: {}", (Object)sw);
                throw new TidyException(tidy.getParseErrors(), tidy.getParseWarnings());
            }
            log.warn("Tidy errors: {}", (Object)sw);
        }
        return doc;
    }

    public static Tidy makeTidyParser(boolean quiet, boolean showWarnings, boolean isXml, StringWriter stringWriter) {
        Tidy tidy = new Tidy();
        tidy.setInputEncoding(StandardCharsets.UTF_8.name());
        tidy.setOutputEncoding(StandardCharsets.UTF_8.name());
        tidy.setQuiet(quiet);
        tidy.setShowWarnings(showWarnings);
        tidy.setMakeClean(true);
        tidy.setXmlTags(isXml);
        if (stringWriter != null) {
            tidy.setErrout(new PrintWriter(stringWriter));
        }
        return tidy;
    }

    private static String getNodeContent(Node node) {
        StringWriter sw = new StringWriter();
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer t = factory.newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerException e) {
            sw.write(e.getMessageAndLocation());
        }
        return sw.toString();
    }

    public static String getValueForNode(Node node) {
        Node firstChild = node.getFirstChild();
        if (firstChild != null) {
            return firstChild.getNodeValue();
        }
        return node.getNodeValue();
    }

    public static NodeList selectNodeList(Document document, String xPathExpression) throws TransformerException {
        XObject xObject = XPathAPI.eval((Node)document, (String)xPathExpression, (PrefixResolver)XPathUtil.getPrefixResolver(document));
        return xObject.nodelist();
    }

    public static void putValuesForXPathInList(Document document, String xPathQuery, List<? super String> matchStrings, boolean fragment) throws TransformerException {
        XPathUtil.putValuesForXPathInList(document, xPathQuery, matchStrings, fragment, -1);
    }

    public static void putValuesForXPathInList(Document document, String xPathQuery, List<? super String> matchStrings, boolean fragment, int matchNumber) throws TransformerException {
        String val = null;
        XObject xObject = XPathAPI.eval((Node)document, (String)xPathQuery, (PrefixResolver)XPathUtil.getPrefixResolver(document));
        int objectType = xObject.getType();
        if (objectType == 4) {
            NodeList matches = xObject.nodelist();
            int length = matches.getLength();
            int indexToMatch = matchNumber;
            if (matchNumber == 0 && length > 0) {
                indexToMatch = JMeterUtils.getRandomInt(length) + 1;
            }
            for (int i = 0; i < length; ++i) {
                Node match = matches.item(i);
                if (indexToMatch >= 0 && indexToMatch != i + 1) continue;
                val = match instanceof Element ? (fragment ? XPathUtil.getNodeContent(match) : XPathUtil.getValueForNode(match)) : match.getNodeValue();
                matchStrings.add(val);
            }
        } else if (objectType == -1 || objectType == 0 || objectType == 600) {
            if (log.isWarnEnabled()) {
                log.warn("Unexpected object type: {} returned for: {}", (Object)xObject.getTypeString(), (Object)xPathQuery);
            }
        } else {
            val = xObject.toString();
            matchStrings.add(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putValuesForXPathInListUsingSaxon(String xmlFile, String xPathQuery, List<? super String> matchStrings, boolean fragment, int matchNumber, String namespaces) throws SaxonApiException, FactoryConfigurationError {
        block22: {
            ImmutablePair key = ImmutablePair.of((Object)xPathQuery, (Object)namespaces);
            if (!StringUtils.isNotEmpty((CharSequence)xPathQuery)) {
                log.warn("Error : {}", (Object)JMeterUtils.getResString("xpath2_extractor_empty_query"));
                return;
            }
            XPathExecutable xPathExecutable = (XPathExecutable)XPATH_CACHE.get((Object)key);
            try (StringReader reader = new StringReader(xmlFile);){
                net.sf.saxon.s9api.DocumentBuilder builder = PROCESSOR.newDocumentBuilder();
                XdmNode xdmNode = builder.build((Source)new SAXSource(new InputSource(reader)));
                if (xPathExecutable == null) break block22;
                XPathSelector selector = null;
                try {
                    selector = xPathExecutable.load();
                    selector.setContextItem((XdmItem)xdmNode);
                    XdmValue nodes = selector.evaluate();
                    int length = nodes.size();
                    int indexToMatch = matchNumber;
                    if (matchNumber < 0) {
                        for (XdmItem item : nodes) {
                            if (fragment) {
                                matchStrings.add(item.toString());
                                continue;
                            }
                            matchStrings.add(item.getStringValue());
                        }
                    } else if (indexToMatch <= length) {
                        if (matchNumber == 0 && length > 0) {
                            indexToMatch = JMeterUtils.getRandomInt(length) + 1;
                        }
                        XdmItem item = nodes.itemAt(indexToMatch - 1);
                        matchStrings.add(fragment ? item.toString() : item.getStringValue());
                    } else if (log.isWarnEnabled()) {
                        log.warn("Error : {}{}", (Object)JMeterUtils.getResString("xpath2_extractor_match_number_failure"), (Object)indexToMatch);
                    }
                }
                finally {
                    if (selector != null) {
                        try {
                            selector.getUnderlyingXPathContext().setContextItem(null);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }

    public static List<String[]> namespacesParse(String namespaces) {
        ArrayList<String[]> res = new ArrayList<String[]>();
        int length = namespaces.length();
        int startWord = 0;
        boolean afterEqual = false;
        int positionLastKey = -1;
        for (int i = 0; i < length; ++i) {
            char actualChar = namespaces.charAt(i);
            if (actualChar == '=' && !afterEqual) {
                String[] tmp = new String[2];
                tmp[0] = namespaces.substring(startWord, i);
                res.add(tmp);
                afterEqual = true;
                startWord = i + 1;
                ++positionLastKey;
                continue;
            }
            if (actualChar == '\n' && afterEqual) {
                afterEqual = false;
                ((String[])res.get((int)positionLastKey))[1] = namespaces.substring(startWord, i);
                startWord = i + 1;
                continue;
            }
            if (actualChar == '\n') {
                startWord = i + 1;
                continue;
            }
            if (i != length - 1 || !afterEqual) continue;
            ((String[])res.get((int)positionLastKey))[1] = namespaces.substring(startWord, i + 1);
        }
        return res;
    }

    public static List<String[]> getNamespaces(String xml) throws XMLStreamException, FactoryConfigurationError {
        ArrayList<String[]> res = new ArrayList<String[]>();
        if (StringUtils.isNotEmpty((CharSequence)xml)) {
            XMLStreamReader reader = XMLInputFactory.newFactory().createXMLStreamReader(new StringReader(xml));
            while (reader.hasNext()) {
                int event = reader.next();
                if (1 != event && 13 != event) continue;
                XPathUtil.addToList(reader, res);
            }
        }
        return res;
    }

    private static void addToList(XMLStreamReader reader, List<String[]> res) {
        boolean isInList = false;
        int namespaceCount = reader.getNamespaceCount();
        if (namespaceCount > 0) {
            for (int nsIndex = 0; nsIndex < namespaceCount; ++nsIndex) {
                String nsPrefix = reader.getNamespacePrefix(nsIndex);
                for (int i = 0; i < res.size(); ++i) {
                    String prefix = res.get(i)[0];
                    if (prefix == null || !prefix.equals(nsPrefix)) continue;
                    isInList = true;
                    break;
                }
                if (!isInList) {
                    String nsId = reader.getNamespaceURI(nsIndex);
                    res.add(new String[]{nsPrefix, nsId});
                }
                isInList = false;
            }
        }
    }

    private static PrefixResolver getPrefixResolver(Document document) {
        return new PropertiesBasedPrefixResolver(document.getDocumentElement());
    }

    public static void validateXPath(Document document, String xpathString) throws TransformerException {
        if (XPathAPI.eval((Node)document, (String)xpathString, (PrefixResolver)XPathUtil.getPrefixResolver(document)) == null) {
            throw new IllegalArgumentException("xpath eval of '" + xpathString + "' was null");
        }
    }

    private static PrefixResolver getPrefixResolverForXPath2(Document document, String namespaces) {
        return new PropertiesBasedPrefixResolverForXpath2(document.getDocumentElement(), namespaces);
    }

    public static void validateXPath2(Document document, String xpathString, String namespaces) throws TransformerException {
        if (XPathAPI.eval((Node)document, (String)xpathString, (PrefixResolver)XPathUtil.getPrefixResolverForXPath2(document, namespaces)) == null) {
            throw new IllegalArgumentException("xpath eval of '" + xpathString + "' was null");
        }
    }

    public static void computeAssertionResult(AssertionResult result, Document doc, String xPathExpression, boolean isNegated) {
        try {
            XObject xObject = XPathAPI.eval((Node)doc, (String)xPathExpression, (PrefixResolver)XPathUtil.getPrefixResolver(doc));
            switch (xObject.getType()) {
                case 4: {
                    NodeList nodeList = xObject.nodelist();
                    int len = nodeList != null ? nodeList.getLength() : 0;
                    log.debug("nodeList length {}", (Object)len);
                    if (len == 0) {
                        log.debug("nodeList is null or empty. No match by xpath expression: {}", (Object)xPathExpression);
                        result.setFailure(!isNegated);
                        result.setFailureMessage("No Nodes Matched " + xPathExpression);
                        return;
                    }
                    if (log.isDebugEnabled() && !isNegated) {
                        for (int i = 0; i < len; ++i) {
                            log.debug("nodeList[{}]: {}", (Object)i, (Object)nodeList.item(i));
                        }
                    }
                    result.setFailure(isNegated);
                    if (isNegated) {
                        result.setFailureMessage("Specified XPath was found... Turn off negate if this is not desired");
                    }
                    return;
                }
                case 1: {
                    boolean resultOfEval = xObject.bool();
                    result.setFailure(isNegated ? resultOfEval : !resultOfEval);
                    result.setFailureMessage(isNegated ? "Nodes Matched for " + xPathExpression : "No Nodes Matched for " + xPathExpression);
                    return;
                }
            }
            result.setFailure(true);
            result.setFailureMessage("Cannot understand: " + xPathExpression);
            return;
        }
        catch (TransformerException e) {
            result.setError(true);
            result.setFailureMessage("TransformerException: " + e.getMessage() + " for: " + xPathExpression);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void computeAssertionResultUsingSaxon(AssertionResult result, String xmlFile, String xPathQuery, String namespaces, Boolean isNegated) throws SaxonApiException, FactoryConfigurationError {
        block21: {
            ImmutablePair key = ImmutablePair.of((Object)xPathQuery, (Object)namespaces);
            if (!StringUtils.isNotEmpty((CharSequence)xPathQuery)) {
                log.warn("Error : {}", (Object)JMeterUtils.getResString("xpath2_extractor_empty_query"));
                return;
            }
            XPathExecutable xPathExecutable = (XPathExecutable)XPATH_CACHE.get((Object)key);
            try (StringReader reader = new StringReader(xmlFile);){
                net.sf.saxon.s9api.DocumentBuilder builder = PROCESSOR.newDocumentBuilder();
                XdmNode xdmNode = builder.build((Source)new SAXSource(new InputSource(reader)));
                if (xPathExecutable == null) break block21;
                XPathSelector selector = null;
                try {
                    Document doc = XPathUtil.makeDocumentBuilder(false, false, false, false).newDocument();
                    XObject xObject = XPathAPI.eval((Node)doc, (String)xPathQuery, (PrefixResolver)XPathUtil.getPrefixResolverForXPath2(doc, namespaces));
                    selector = xPathExecutable.load();
                    selector.setContextItem((XdmItem)xdmNode);
                    XdmValue nodes = selector.evaluate();
                    boolean resultOfEval = true;
                    int length = nodes.size();
                    if (length == 0) {
                        resultOfEval = false;
                    } else if (xObject.getType() == 1) {
                        resultOfEval = Boolean.parseBoolean(nodes.itemAt(0).getStringValue());
                    }
                    result.setFailure(isNegated != false ? resultOfEval : !resultOfEval);
                    result.setFailureMessage(isNegated != false ? "Nodes Matched for " + xPathQuery : "No Nodes Matched for " + xPathQuery);
                }
                catch (ParserConfigurationException | TransformerException e) {
                    result.setError(true);
                    result.setFailureMessage("Exception: " + e.getMessage() + " for:" + xPathQuery);
                }
                finally {
                    if (selector != null) {
                        try {
                            selector.getUnderlyingXPathContext().setContextItem(null);
                        }
                        catch (Exception e) {
                            result.setError(true);
                            result.setFailureMessage("Exception: " + e.getMessage() + " for:" + xPathQuery);
                        }
                    }
                }
            }
        }
    }

    public static String formatXml(String xml) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer serializer = factory.newTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            SAXSource xmlSource = new SAXSource(new InputSource(new StringReader(xml)));
            StringWriter stringWriter = new StringWriter();
            StreamResult res = new StreamResult(stringWriter);
            serializer.transform(xmlSource, res);
            return stringWriter.toString();
        }
        catch (Exception e) {
            return xml;
        }
    }

    static {
        int cacheSize = JMeterUtils.getPropDefault("xpath2query.parser.cache.size", 400);
        XPATH_CACHE = Caffeine.newBuilder().maximumSize((long)cacheSize).build((CacheLoader)new XPathQueryCacheLoader());
        PROCESSOR = new Processor(false);
    }

    static class MyErrorHandler
    implements ErrorHandler {
        private final boolean val;
        private final boolean tol;
        private final String type;

        MyErrorHandler(boolean validate, boolean tolerate) {
            this.val = validate;
            this.tol = tolerate;
            this.type = "Val=" + this.val + " Tol=" + this.tol;
        }

        @Override
        public void warning(SAXParseException ex) throws SAXException {
            if (log.isInfoEnabled()) {
                log.info("Type={}. {}", (Object)this.type, (Object)ex.toString());
            }
            if (this.val && !this.tol) {
                throw new SAXException(ex);
            }
        }

        @Override
        public void error(SAXParseException ex) throws SAXException {
            if (log.isWarnEnabled()) {
                log.warn("Type={}. {}", (Object)this.type, (Object)ex.toString());
            }
            if (this.val && !this.tol) {
                throw new SAXException(ex);
            }
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXException {
            log.error("Type={}. {}", (Object)this.type, (Object)ex.toString());
            if (this.val && !this.tol) {
                throw new SAXException(ex);
            }
        }
    }
}

