/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.geom;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001cB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0012\u001a\u00020\u0000J\u0006\u0010\u0013\u001a\u00020\u0007J\n\u0010\u0014\u001a\u00060\u0015R\u00020\u0000J\u001a\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u0019J\u001e\u0010\u001b\u001a\u00020\u00172\u0016\u0010\u0018\u001a\u0012\u0012\b\u0012\u00060\u0015R\u00020\u0000\u0012\u0004\u0012\u00020\u00170\u0019R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/letsPlot/geom/Raster;", "", "width", "", "height", "nChannels", "isDTypeF", "", "pixels", "", "(IIIZ[F)V", "getHeight", "()I", "()Z", "getNChannels", "getPixels", "()[F", "getWidth", "addChannel", "hasNan", "pixel", "Lorg/jetbrains/letsPlot/geom/Raster$Pixel;", "updateChannels", "", "f", "Lkotlin/Function1;", "", "updatePixels", "Pixel", "plot-api"})
@SourceDebugExtension(value={"SMAP\ngeom_imshow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 geom_imshow.kt\norg/jetbrains/letsPlot/geom/Raster\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,489:1\n12524#2,2:490\n*S KotlinDebug\n*F\n+ 1 geom_imshow.kt\norg/jetbrains/letsPlot/geom/Raster\n*L\n487#1:490,2\n*E\n"})
public final class Raster {
    private final int width;
    private final int height;
    private final int nChannels;
    private final boolean isDTypeF;
    @NotNull
    private final float[] pixels;

    public Raster(int width, int height, int nChannels, boolean isDTypeF, @NotNull float[] pixels) {
        Intrinsics.checkNotNullParameter((Object)pixels, (String)"pixels");
        this.width = width;
        this.height = height;
        this.nChannels = nChannels;
        this.isDTypeF = isDTypeF;
        this.pixels = pixels;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getNChannels() {
        return this.nChannels;
    }

    public final boolean isDTypeF() {
        return this.isDTypeF;
    }

    @NotNull
    public final float[] getPixels() {
        return this.pixels;
    }

    public final void updatePixels(@NotNull Function1<? super Pixel, Unit> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        Pixel pixel = new Pixel();
        int n = this.height;
        for (int y = 0; y < n; ++y) {
            int n2 = this.width;
            for (int x = 0; x < n2; ++x) {
                f.invoke((Object)pixel.atXY(x, y));
            }
        }
    }

    public final void updateChannels(@NotNull Function1<? super Float, Float> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        this.updatePixels((Function1<? super Pixel, Unit>)((Function1)new Function1<Pixel, Unit>(this, f){
            final /* synthetic */ Raster this$0;
            final /* synthetic */ Function1<Float, Float> $f;
            {
                this.this$0 = $receiver;
                this.$f = $f;
                super(1);
            }

            public final void invoke(@NotNull Pixel ch) {
                Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
                if (this.this$0.getNChannels() >= 1) {
                    ch.set(0, ((Number)this.$f.invoke((Object)Float.valueOf(ch.get(0)))).floatValue());
                }
                if (this.this$0.getNChannels() >= 2) {
                    ch.set(1, ((Number)this.$f.invoke((Object)Float.valueOf(ch.get(1)))).floatValue());
                }
                if (this.this$0.getNChannels() >= 3) {
                    ch.set(2, ((Number)this.$f.invoke((Object)Float.valueOf(ch.get(2)))).floatValue());
                }
                if (this.this$0.getNChannels() >= 4) {
                    ch.set(3, ((Number)this.$f.invoke((Object)Float.valueOf(ch.get(3)))).floatValue());
                }
            }
        }));
    }

    @NotNull
    public final Raster addChannel() {
        float[] newPixels = new float[this.width * this.height * (this.nChannels + 1)];
        int newI = 0;
        for (float newPixels[newI++] : this.pixels) {
            if (newI % this.nChannels != 0) continue;
            newPixels[newI++] = Float.NaN;
        }
        return new Raster(this.width, this.height, this.nChannels + 1, this.isDTypeF, newPixels);
    }

    @NotNull
    public final Pixel pixel() {
        return new Pixel();
    }

    public final boolean hasNan() {
        boolean bl;
        block1: {
            float[] $this$any$iv = this.pixels;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                float element$iv;
                float p0 = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!Float.isNaN(p0)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00060\u0000R\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0011\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0004H\u0086\u0002J\u0019\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000bH\u0086\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/geom/Raster$Pixel;", "", "(Lorg/jetbrains/letsPlot/geom/Raster;)V", "pxIndex", "", "atXY", "Lorg/jetbrains/letsPlot/geom/Raster;", "x", "y", "channels", "", "", "get", "chIndex", "set", "", "v", "plot-api"})
    public final class Pixel {
        private int pxIndex;

        @NotNull
        public final Pixel atXY(int x, int y) {
            this.pxIndex = (y * Raster.this.getWidth() + x) * Raster.this.getNChannels();
            return this;
        }

        public final float get(int chIndex) {
            return Raster.this.getPixels()[this.pxIndex + chIndex];
        }

        public final void set(int chIndex, float v) {
            Raster.this.getPixels()[this.pxIndex + chIndex] = v;
        }

        @NotNull
        public final List<Float> channels() {
            List list;
            switch (Raster.this.getNChannels()) {
                case 1: {
                    list = CollectionsKt.listOf((Object)Float.valueOf(this.get(0)));
                    break;
                }
                case 2: {
                    Object[] objectArray = new Float[]{Float.valueOf(this.get(0)), Float.valueOf(this.get(1))};
                    list = CollectionsKt.listOf((Object[])objectArray);
                    break;
                }
                case 3: {
                    Object[] objectArray = new Float[]{Float.valueOf(this.get(0)), Float.valueOf(this.get(1)), Float.valueOf(this.get(2))};
                    list = CollectionsKt.listOf((Object[])objectArray);
                    break;
                }
                case 4: {
                    Object[] objectArray = new Float[]{Float.valueOf(this.get(0)), Float.valueOf(this.get(1)), Float.valueOf(this.get(2)), Float.valueOf(this.get(3))};
                    list = CollectionsKt.listOf((Object[])objectArray);
                    break;
                }
                default: {
                    throw new IllegalStateException(("Unsupported number of channels: " + Raster.this.getNChannels()).toString());
                }
            }
            return list;
        }
    }
}

