/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.util.datautil;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;

public class EffectData
extends BlockPos {
    private final Long time;
    private final int amplifier;
    private final int taskId;

    public EffectData(BlockPos pos, Long time) {
        super(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        this.time = time;
        this.amplifier = 0;
        this.taskId = 0;
    }

    public EffectData(BlockPos pos, Long time, int amplifier) {
        super(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        this.time = time;
        this.amplifier = amplifier;
        this.taskId = 0;
    }

    public EffectData(BlockPos pos, Long time, int amplifier, int taskId) {
        super(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        this.time = time;
        this.amplifier = amplifier;
        this.taskId = taskId;
    }

    public Long getTime() {
        return this.time;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public int getTaskId() {
        return this.taskId;
    }

    public CompoundTag saveToNBT(String effectID) {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_(effectID + "position", this.m_121878_());
        tag.m_128356_(effectID + "duration", this.getTime().longValue());
        tag.m_128405_(effectID + "amplifier", this.getAmplifier());
        tag.m_128405_(effectID + "task", this.getTaskId());
        return tag;
    }

    public static EffectData loadFromNBT(CompoundTag tag, String effectID) {
        BlockPos position = BlockPos.m_122022_((long)tag.m_128454_(effectID + "position"));
        long duration = tag.m_128454_(effectID + "duration");
        int amplifier = tag.m_128451_(effectID + "amplifier");
        int taskID = tag.m_128451_(effectID + "task");
        return new EffectData(position, duration, amplifier, taskID);
    }
}

