/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.ai;

import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.IChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement.TextChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.debug.annotation.SafeRun;
import com.github.wallev.maidsoulkitchen.debug.annotation.TimeRecord;
import com.github.wallev.maidsoulkitchen.init.MkEntities;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.MaidCookManager;
import com.github.wallev.maidsoulkitchen.util.MemoryUtil;
import com.github.wallev.maidsoulkitchen.vhelper.client.chat.VComponent;
import com.github.wallev.maidsoulkitchen.vhelper.server.ai.VBehaviorControl;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.crafting.Recipe;

public class GenerateRecsTask<R extends Recipe<? extends Container>>
extends Behavior<EntityMaid>
implements VBehaviorControl {
    private final MaidCookManager<R> cm;

    public GenerateRecsTask(MaidCookManager<R> cm) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)MkEntities.GENERATE_RECS.get()), (Object)MemoryStatus.VALUE_PRESENT));
        this.cm = cm;
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, EntityMaid pOwner) {
        return this.cm.getRunState() == 2;
    }

    @TimeRecord
    @SafeRun
    protected void start(ServerLevel pLevel, EntityMaid pEntity, long pGameTime) {
        MutableComponent append = VComponent.translatable("chat_bubble.maidsoulkitchen.cook.collect_ingredients");
        TextChatBubbleData textChatBubbleData = TextChatBubbleData.type2((Component)append);
        pEntity.getChatBubbleManager().addChatBubble((IChatBubbleData)textChatBubbleData);
    }

    protected boolean canStillUse(ServerLevel pLevel, EntityMaid pEntity, long pGameTime) {
        return !this.cm.recsGenerateDone();
    }

    @TimeRecord
    @SafeRun
    protected void tick(ServerLevel pLevel, EntityMaid pOwner, long pGameTime) {
        this.cm.tickGenerateRecs();
    }

    protected void stop(ServerLevel pLevel, EntityMaid pEntity, long pGameTime) {
        MemoryUtil.eraseGenerateRecs(pEntity);
        this.cm.recsGenDoneAndUpdate();
    }

    protected boolean m_7773_(long pGameTime) {
        return false;
    }
}

