/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2serial.serialization.generic_types;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2serial.serialization.generic_types.GenericCodec;
import dev.xkmc.l2serial.serialization.type_cache.TypeInfo;
import dev.xkmc.l2serial.serialization.unified_processor.UnifiedCodec;
import dev.xkmc.l2serial.serialization.unified_processor.UnifiedContext;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class MapCodec
extends GenericCodec {
    @Override
    public boolean predicate(TypeInfo cls, @Nullable Object obj) {
        return Map.class.isAssignableFrom(cls.getAsClass());
    }

    @Override
    public <C extends UnifiedContext<E, O, A>, E, O extends E, A extends E> Object deserializeValue(C ctx, E e, TypeInfo cls, @Nullable Object ans) throws Exception {
        if (ans == null) {
            ans = cls.newInstance();
        }
        TypeInfo ckey = cls.getGenericType(0);
        TypeInfo cval = cls.getGenericType(1);
        if (ctx.isListFormat(e)) {
            A arr = ctx.castAsList(e);
            int n = ctx.getSize(arr);
            ((Map)ans).clear();
            for (int i = 0; i < n; ++i) {
                O jeo = ctx.castAsMap(ctx.getElement(arr, i));
                Object key = UnifiedCodec.deserializeValue(ctx, ctx.getKeyOfEntry(jeo), ckey, null);
                Object val = UnifiedCodec.deserializeValue(ctx, ctx.getValueOfEntry(jeo), cval, null);
                ((Map)ans).put(key, val);
            }
            return ans;
        }
        return ctx.deserializeEfficientMap(e, ckey, cval, ans);
    }

    @Override
    public <C extends UnifiedContext<E, O, A>, E, O extends E, A extends E> E serializeValue(C ctx, TypeInfo cls, @Nullable Object obj) throws Exception {
        Map map = (Map)obj;
        TypeInfo ckey = cls.getGenericType(0);
        TypeInfo cval = cls.getGenericType(1);
        ArrayList<Pair> list = new ArrayList<Pair>();
        A lans = ctx.createList(map.size());
        boolean can_be_map = true;
        for (Map.Entry entry : map.entrySet()) {
            Object k = UnifiedCodec.serializeValue(ctx, ckey, entry.getKey());
            Object v = UnifiedCodec.serializeValue(ctx, cval, entry.getValue());
            list.add(Pair.of(k, v));
            can_be_map &= ctx.canBeString(k);
        }
        if (can_be_map) {
            O ans = ctx.createMap();
            for (Pair p : list) {
                ctx.addField(ans, ctx.getAsString((Object)p.getFirst()), (Object)p.getSecond());
            }
            return (E)ans;
        }
        for (Pair pair : list) {
            O entry = ctx.createMap();
            ctx.setKeyOfEntry(entry, (Object)pair.getFirst());
            ctx.setValueOfEntry(entry, (Object)pair.getSecond());
            ctx.addListItem(lans, entry);
        }
        return (E)lans;
    }
}

