/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2serial.serialization.unified_processor;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.l2serial.serialization.custom_handler.Handlers;
import dev.xkmc.l2serial.serialization.type_cache.FieldCache;
import dev.xkmc.l2serial.serialization.type_cache.TypeInfo;
import dev.xkmc.l2serial.serialization.unified_processor.TreeContext;
import dev.xkmc.l2serial.serialization.unified_processor.UnifiedCodec;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class TagContext
extends TreeContext<Tag, CompoundTag, ListTag> {
    private static final CompoundTag NULL = new CompoundTag();
    private final Predicate<SerialClass.SerialField> pred;

    public TagContext(Predicate<SerialClass.SerialField> pred) {
        super(Optional.of(Pair.of((Object)NULL, Optional.empty())));
        this.pred = pred;
    }

    @Override
    public Optional<Either<Optional<Object>, TypeInfo>> fetchRealClass(@Nullable Tag e, TypeInfo def) throws Exception {
        String scls;
        Tag tcls;
        CompoundTag obj;
        CompoundTag tag;
        if (e == null || e instanceof CompoundTag && (tag = (CompoundTag)e).m_128441_("_null")) {
            return Optional.of(Either.left(Optional.empty()));
        }
        if (e instanceof CompoundTag && (obj = (CompoundTag)e).m_128441_("_class") && (tcls = obj.m_128423_("_class")) != null && !(scls = tcls.m_7916_()).isEmpty()) {
            return Optional.of(Either.right((Object)TypeInfo.of(Class.forName(scls))));
        }
        return Optional.empty();
    }

    @Override
    public Object deserializeEfficientMap(Tag tag, TypeInfo key, TypeInfo val, Object def) throws Exception {
        CompoundTag ctag = (CompoundTag)tag;
        Map map = (Map)def;
        map.clear();
        for (String str : ctag.m_128431_()) {
            String mkey = key.getAsClass() == String.class ? str : (key.getAsClass().isEnum() ? Enum.valueOf(key.getAsClass(), str) : Handlers.NBT_MAP.get(key.getAsClass()).fromTag((Tag)StringTag.m_129297_((String)str)));
            Tag t = ctag.m_128423_(str);
            map.put(mkey, UnifiedCodec.deserializeValue(this, t == null ? NULL : t, val, null));
        }
        return map;
    }

    @Override
    public boolean hasSpecialHandling(Class<?> cls) {
        return Handlers.NBT_MAP.containsKey(cls);
    }

    @Override
    public Object deserializeSpecial(Class<?> cls, Tag e) {
        return Handlers.NBT_MAP.get(cls).fromTag(e);
    }

    @Override
    public Tag serializeSpecial(Class<?> cls, Object obj) {
        return Handlers.NBT_MAP.get(cls).toTag(obj);
    }

    @Override
    public boolean shouldRead(CompoundTag obj, FieldCache field) throws Exception {
        return this.pred.test(field.getSerialAnnotation()) && obj.m_128441_(field.getName());
    }

    @Override
    public Tag retrieve(CompoundTag obj, String field) {
        Tag t = obj.m_128423_(field);
        return t == null ? NULL : t;
    }

    @Override
    public ListTag castAsList(Tag e) {
        return (ListTag)e;
    }

    @Override
    public int getSize(ListTag arr) {
        return arr.size();
    }

    @Override
    public Tag getElement(ListTag arr, int i) {
        return arr.get(i);
    }

    @Override
    public boolean isListFormat(Tag e) {
        return e instanceof ListTag;
    }

    @Override
    public CompoundTag castAsMap(Tag e) {
        return (CompoundTag)e;
    }

    @Override
    public String getAsString(Tag e) {
        if (e == NULL) {
            return "";
        }
        return e.m_7916_();
    }

    @Override
    public void addField(CompoundTag obj, String str, @Nullable Tag e) {
        if (e != null) {
            obj.m_128365_(str, e);
        }
    }

    @Override
    public ListTag createList(int size) {
        return new ListTag();
    }

    @Override
    public CompoundTag createMap() {
        return new CompoundTag();
    }

    @Override
    public void addListItem(ListTag arr, Tag e) {
        arr.add((Object)e);
    }

    @Override
    public boolean canBeString(Tag e) {
        return e instanceof StringTag;
    }

    @Override
    public Tag fromString(String str) {
        return StringTag.m_129297_((String)str);
    }

    static {
        NULL.m_128379_("_null", true);
    }
}

