/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook;

import com.github.wallev.maidsoulkitchen.task.cook.common.cook.be.CookBeBase;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.maid.IMaidCookInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.GatherResult;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.MaidCookManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook.AbstractCookRule;
import com.github.wallev.maidsoulkitchen.util.MaidUtil;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class FdPotCookRule<B extends BlockEntity, R extends Recipe<? extends Container>>
extends AbstractCookRule<B, R> {
    private static final FdPotCookRule INSTANCE = new FdPotCookRule();

    public static <B extends BlockEntity, R extends Recipe<? extends Container>> FdPotCookRule<B, R> getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean canMoveTo(CookBeBase<B> cookBeBase, MaidCookManager<R> cm) {
        IMaidCookInventory cookInv = cm.getCookInv();
        boolean hasInputAvailableSlot = cookInv.hasInputAvailableSlot();
        boolean hasOutputAvailableSlot = cookInv.hasOutputAvailableSlot();
        boolean canTakeResult = cookBeBase.canTakeResult();
        boolean hasResult = cookBeBase.hasResult();
        if (canTakeResult && hasResult && hasOutputAvailableSlot) {
            return true;
        }
        boolean hasMeal = cookBeBase.hasMeal();
        ItemStack nowContainer = cookBeBase.getNowContainer();
        boolean hasContainer = !nowContainer.m_41619_();
        ItemStack needContainer = cookBeBase.getNeedContainer();
        if (hasMeal && hasOutputAvailableSlot && (hasContainer ? hasInputAvailableSlot && !needContainer.m_41619_() && cm.hasItem(needContainer) : !needContainer.m_41619_() && cm.hasItem(needContainer))) {
            return true;
        }
        boolean recMatch = cookBeBase.recMatch();
        boolean hasInputs = cookBeBase.hasInputs();
        if (hasInputs && hasInputAvailableSlot && !recMatch) {
            return true;
        }
        if (hasContainer && hasInputAvailableSlot && !hasInputs) {
            return true;
        }
        boolean matchCookState = cookBeBase.cookStateMatch();
        return matchCookState && !recMatch && !hasMeal && !hasInputs && cm.hasMaidRecs(cookBeBase);
    }

    @Override
    public void cookMake(CookBeBase<B> cookBeBase, MaidCookManager<R> cm) {
        boolean matchCookState;
        boolean pickAction = false;
        IItemHandlerModifiable inputInv = cm.getInputInv();
        IItemHandlerModifiable outputInv = cm.getOutputInv();
        IMaidCookInventory cookInv = cm.getCookInv();
        boolean hasInputAvailableSlot = cookInv.hasInputAvailableSlot();
        boolean hasOutputAvailableSlot = cookInv.hasOutputAvailableSlot();
        ItemStack meal = cookBeBase.getMeal();
        ItemStack nowContainer = cookBeBase.getNowContainer();
        if (!meal.m_41619_()) {
            ItemStack needContainer;
            GatherResult gatherResult;
            if (!nowContainer.m_41619_()) {
                cookBeBase.takeItem(nowContainer, (IItemHandler)inputInv);
                pickAction = true;
            }
            if (!(gatherResult = cm.getItem(needContainer = cookBeBase.getNeedContainer())).isFail()) {
                ItemStack queryItemStack = gatherResult.queryItemStack(64);
                cookBeBase.insertContainer(queryItemStack);
                cookBeBase.markChanged();
                gatherResult.backItemStack(queryItemStack);
                pickAction = true;
            }
        }
        boolean canTakeResult = cookBeBase.canTakeResult();
        ItemStack result = cookBeBase.getResult();
        if (canTakeResult && !result.m_41619_() && hasOutputAvailableSlot) {
            boolean taken = cookBeBase.takeItem(result, (IItemHandler)outputInv);
            cookBeBase.awardExp();
            cookBeBase.markChanged();
            if (taken) {
                pickAction = true;
            }
        }
        boolean recMatch = cookBeBase.recMatch();
        boolean hasInputs = cookBeBase.hasInputs();
        if (hasInputs && hasInputAvailableSlot && !recMatch) {
            cookBeBase.takeInputs((IItemHandler)inputInv);
            cookBeBase.markChanged();
            pickAction = true;
        }
        if (!nowContainer.m_41619_() && hasInputAvailableSlot && !hasInputs) {
            cookBeBase.takeItem(nowContainer, (IItemHandler)inputInv);
            cookBeBase.markChanged();
            pickAction = true;
        }
        if ((matchCookState = cookBeBase.cookStateMatch()) && !hasInputs && !recMatch && meal.m_41619_() && cm.hasMaidRecs(cookBeBase)) {
            ItemInventory itemInventory = cm.getItemInventory();
            cookBeBase.insertInputs(cm.pollMaidRec(cookBeBase), itemInventory);
            cookBeBase.markChanged();
            cm.getItemInventory().markDirty();
            pickAction = true;
        }
        if (pickAction) {
            MaidUtil.pickupAction(cookBeBase);
        }
    }
}

