/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.farm.handler.fruit;

import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.Mods;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.github.wallev.maidsoulkitchen.task.farm.handler.IFarmHandlerManager;
import com.github.wallev.maidsoulkitchen.task.farm.handler.fruit.CompatFruitHandler;
import com.github.wallev.maidsoulkitchen.task.farm.handler.fruit.FruitHandler;
import com.github.wallev.maidsoulkitchen.task.farm.handler.fruit.SimpleFarmingFruitHandler;
import com.github.wallev.maidsoulkitchen.vhelper.client.resources.VResourceLocation;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public enum FruitHandlerManager implements IFarmHandlerManager<FruitHandler>
{
    SIMPLE_FARMING(TaskInfo.FRUIT_SIMPLE_FARMING, SimpleFarmingFruitHandler::new),
    COMPAT(TaskInfo.FRUIT_COMPAT, CompatFruitHandler::new);

    public static final FruitHandlerManager[] VALUES;
    private final ResourceLocation uid;
    private final Mods bindMod;
    private final Supplier<FruitHandler> fruitHandler;

    private FruitHandlerManager(TaskInfo taskInfo, Supplier<FruitHandler> berryHandler) {
        this(taskInfo.getUid(), taskInfo.getBindMod(), berryHandler);
    }

    private FruitHandlerManager(ResourceLocation uid, Mods bindMod, Supplier<FruitHandler> berryHandler) {
        this.uid = uid;
        this.bindMod = bindMod;
        this.fruitHandler = berryHandler;
    }

    private FruitHandlerManager(String uid, Mods bindMod, Supplier<FruitHandler> berryHandler) {
        this(FruitHandlerManager.create(uid), bindMod, berryHandler);
    }

    static ResourceLocation create(String uid) {
        return VResourceLocation.create("maidsoulkitchen", uid);
    }

    @Override
    public FruitHandler getFarmHandler() {
        return this.fruitHandler.get();
    }

    public ResourceLocation getUid() {
        return this.uid;
    }

    public Mods getBindMod() {
        return this.bindMod;
    }

    static {
        VALUES = FruitHandlerManager.values();
    }
}

