/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.context.special;

import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityAltar;
import com.github.tartaricacid.touhoulittlemaid.util.PosListData;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import studio.fantasyit.maid_storage_manager.craft.context.AbstractCraftActionContext;
import studio.fantasyit.maid_storage_manager.craft.context.AbstractDynamicAddedAction;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonPickupItemAction;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonUseAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.PosUtil;
import studio.fantasyit.maid_storage_manager.util.RecipeUtil;

public class AltarRecipeAction
extends AbstractDynamicAddedAction {
    public static final ResourceLocation TYPE = new ResourceLocation("maid_storage_manager", "altar");

    public AltarRecipeAction(EntityMaid maid, CraftGuideData craftGuideData, CraftGuideStepData craftGuideStepData, CraftLayer layer) {
        super(maid, craftGuideData, craftGuideStepData, layer);
    }

    @Override
    public AbstractCraftActionContext.Result getList() {
        Optional<AltarRecipe> recipe = RecipeUtil.getAltarRecipe(this.maid.m_9236_(), RecipeUtil.wrapAltarRecipeInventory(this.craftGuideStepData.getInput()));
        if (recipe.isEmpty()) {
            return AbstractCraftActionContext.Result.FAIL;
        }
        float cost = recipe.get().getPowerCost();
        BlockPos target = this.craftGuideStepData.getStorage().pos;
        BlockEntity blockEntity = this.maid.m_9236_().m_7702_(target);
        if (blockEntity instanceof TileEntityAltar) {
            TileEntityAltar tea = (TileEntityAltar)blockEntity;
            PosListData canPlaceItemPosList = tea.getCanPlaceItemPosList();
            List data = canPlaceItemPosList.getData();
            List<ItemStack> inputs = this.craftGuideStepData.getNonEmptyInput();
            int totalUsed = Math.min(data.size(), inputs.size());
            for (int i = 0; i < totalUsed; ++i) {
                this.addStep(new CraftGuideStepData(Target.virtual((BlockPos)data.get(i), null), List.of(inputs.get(i)), List.of(ItemStack.f_41583_), CommonUseAction.TYPE));
            }
            this.addStep(new CraftGuideStepData(Target.virtual(this.getCenterPos(data), null), List.of(), List.of(this.craftGuideStepData.getNonEmptyOutput().get(0)), CommonPickupItemAction.TYPE));
        }
        return AbstractCraftActionContext.Result.SUCCESS;
    }

    BlockPos getCenterPos(List<BlockPos> data) {
        int ty;
        long acX = 0L;
        long acZ = 0L;
        long acY = 0L;
        for (int i = 0; i < data.size(); ++i) {
            int c = 0;
            for (int j = 0; j < data.size(); ++j) {
                if (i == j || data.get(i).m_123341_() != data.get(j).m_123341_() && data.get(i).m_123343_() != data.get(j).m_123343_()) continue;
                ++c;
            }
            if (c != 2) continue;
            acX += (long)data.get(i).m_123341_();
            acZ += (long)data.get(i).m_123343_();
            acY += (long)data.get(i).m_123342_();
        }
        for (ty = (int)(acY / 4L); !PosUtil.isSafePos(this.maid.m_9236_(), new BlockPos((int)(acX / 4L), ty, (int)(acZ / 4L))) && ty > this.maid.m_9236_().m_141937_(); --ty) {
        }
        return new BlockPos((int)(acX / 4L), ty, (int)(acZ / 4L));
    }
}

