/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.context.special;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.items.IItemHandler;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOption;
import studio.fantasyit.maid_storage_manager.craft.context.AbstractCraftActionContext;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class AnvilRecipeAction
extends AbstractCraftActionContext {
    public static final ActionOption<Boolean> OPTION_ANVIL_NAME = ActionOption.valueOnly(new ResourceLocation("maid_storage_manager", "anvil_name"), "");
    FakePlayer player;
    Access access;
    ServerLevel level;

    public AnvilRecipeAction(EntityMaid maid, CraftGuideData craftGuideData, CraftGuideStepData craftGuideStepData, CraftLayer layer) {
        super(maid, craftGuideData, craftGuideStepData, layer);
        this.access = craftGuideStepData.getStorage() != null ? new Access(maid.m_9236_(), craftGuideStepData.getStorage().getPos()) : null;
        this.level = (ServerLevel)maid.m_9236_();
    }

    @Override
    public AbstractCraftActionContext.Result start() {
        if (this.access == null) {
            return AbstractCraftActionContext.Result.FAIL;
        }
        this.player = FakePlayerFactory.get((ServerLevel)((ServerLevel)this.maid.m_9236_()), (GameProfile)new GameProfile(UUID.randomUUID(), this.maid.m_7755_().getString()));
        return AbstractCraftActionContext.Result.CONTINUE;
    }

    private int getCostForLevel(int experience, int costLevel) {
        int level = 0;
        int tLevelCost = this.getToNext(level);
        for (int tExp = experience; tExp >= tLevelCost && level < 100000; tExp -= tLevelCost) {
            tLevelCost = this.getToNext(++level);
        }
        if (level < costLevel) {
            return Integer.MAX_VALUE;
        }
        int costPoint = 0;
        for (int i = 0; i < costLevel; ++i) {
            costPoint += this.getToNext(level - i - 1);
        }
        return costPoint;
    }

    private int getToNext(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        return level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2;
    }

    @Override
    public AbstractCraftActionContext.Result tick() {
        if (!this.level.m_8055_(this.craftGuideStepData.storage.pos).m_204336_(BlockTags.f_13033_)) {
            return AbstractCraftActionContext.Result.NOT_DONE;
        }
        AnvilMenu anvilMenu = new AnvilMenu(0, this.player.m_150109_(), (ContainerLevelAccess)this.access);
        ItemStack t1 = InvUtil.tryExtractForCrafting((IItemHandler)this.maid.getAvailableInv(false), this.craftGuideStepData.getInput().get(0));
        ItemStack t2 = InvUtil.tryExtractForCrafting((IItemHandler)this.maid.getAvailableInv(false), this.craftGuideStepData.getInput().get(1));
        if (!ItemStackUtil.isSameInCrafting(t1, this.craftGuideStepData.getInput().get(0)) || !ItemStackUtil.isSameInCrafting(t2, this.craftGuideStepData.getInput().get(1))) {
            InvUtil.tryPlace((IItemHandler)this.maid.getAvailableInv(false), t1);
            InvUtil.tryPlace((IItemHandler)this.maid.getAvailableInv(false), t2);
            return AbstractCraftActionContext.Result.FAIL;
        }
        anvilMenu.m_182406_(0, 0, t1);
        anvilMenu.m_182406_(1, 0, t2);
        anvilMenu.m_39020_(this.craftGuideStepData.getExtraData().m_128461_("name"));
        anvilMenu.m_6640_();
        ItemStack result = anvilMenu.m_38853_(2).m_7993_();
        int cost = anvilMenu.m_39028_();
        int pointCost = this.getCostForLevel(this.maid.getExperience(), cost);
        if (result != ItemStack.f_41583_ && ItemStackUtil.isSameInCrafting(result, this.craftGuideStepData.getOutput().get(0)) && this.maid.getExperience() >= pointCost && ItemStackUtil.isSameInCrafting(t1, this.craftGuideStepData.getInput().get(0)) && ItemStackUtil.isSameInCrafting(t2, this.craftGuideStepData.getInput().get(1))) {
            anvilMenu.m_142365_((Player)this.player, result);
            InvUtil.tryPlace((IItemHandler)this.maid.getAvailableInv(false), result.m_41777_());
            this.maid.setExperience(this.maid.getExperience() - pointCost);
            this.craftLayer.addCurrentStepPlacedCounts(0, result.m_41613_());
            return AbstractCraftActionContext.Result.SUCCESS;
        }
        InvUtil.tryPlace((IItemHandler)this.maid.getAvailableInv(false), t1);
        InvUtil.tryPlace((IItemHandler)this.maid.getAvailableInv(false), t2);
        return AbstractCraftActionContext.Result.FAIL;
    }

    @Override
    public void stop() {
    }

    protected static class Access
    implements ContainerLevelAccess {
        private final BlockPos pos;
        private final Level level;

        public Access(Level level, BlockPos pos) {
            this.level = level;
            this.pos = pos;
        }

        public <T> Optional<T> m_6721_(BiFunction<Level, BlockPos, T> p_39298_) {
            return Optional.ofNullable(p_39298_.apply(this.level, this.pos));
        }
    }
}

