/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.context.special;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.tacz.guns.crafting.GunSmithTableIngredient;
import com.tacz.guns.crafting.GunSmithTableRecipe;
import com.tacz.guns.init.ModRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOption;
import studio.fantasyit.maid_storage_manager.craft.context.AbstractCraftActionContext;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.integration.tacz.TaczRecipe;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class TaczRecipeAction
extends AbstractCraftActionContext {
    public static final ActionOption<Boolean> OPTION_TACZ_RECIPE_ID = new ActionOption<Boolean>(new ResourceLocation("maid_storage_manager", "recipe_id"), "", new ActionOption.BiConverter<Integer, Boolean>(i -> i != 0, t -> t != false ? 1 : 0), ActionOption.ValuePredicatorOrGetter.predicator(ResourceLocation::m_135830_));
    public static final ActionOption<Boolean> OPTION_TACZ_BLOCK_ID = new ActionOption<Boolean>(new ResourceLocation("maid_storage_manager", "block_id"), "", new ActionOption.BiConverter<Integer, Boolean>(i -> i != 0, t -> t != false ? 1 : 0), ActionOption.ValuePredicatorOrGetter.predicator(ResourceLocation::m_135830_));

    public TaczRecipeAction(EntityMaid maid, CraftGuideData craftGuideData, CraftGuideStepData craftGuideStepData, CraftLayer layer) {
        super(maid, craftGuideData, craftGuideStepData, layer);
    }

    @Override
    public AbstractCraftActionContext.Result start() {
        if (this.craftGuideStepData.getStorage() == null) {
            return AbstractCraftActionContext.Result.FAIL;
        }
        return AbstractCraftActionContext.Result.CONTINUE;
    }

    @Override
    public AbstractCraftActionContext.Result tick() {
        int maxCanPlace;
        Level level = this.maid.m_9236_();
        String wantedBlockId = this.craftGuideStepData.getOptionValue(OPTION_TACZ_BLOCK_ID);
        String recipeId = this.craftGuideStepData.getOptionValue(OPTION_TACZ_RECIPE_ID);
        if (!TaczRecipe.getBlockId(level, this.craftGuideStepData.storage.pos).toString().equals(wantedBlockId)) {
            return AbstractCraftActionContext.Result.NOT_DONE;
        }
        Optional<GunSmithTableRecipe> recipe = level.m_7465_().m_44013_((RecipeType)ModRecipe.GUN_SMITH_TABLE_CRAFTING.get()).stream().filter(r -> r.m_6423_().toString().equals(recipeId)).findFirst();
        CombinedInvWrapper inv = this.maid.getAvailableInv(false);
        List<ItemStack> input = this.craftGuideStepData.getInput();
        List<ItemStack> output = this.craftGuideStepData.getOutput();
        ArrayList<ItemStack> taken = new ArrayList<ItemStack>();
        if (recipe.isEmpty()) {
            return AbstractCraftActionContext.Result.FAIL;
        }
        List recipeInput = recipe.get().getInputs();
        for (int i = 0; i < Math.max(input.size(), recipeInput.size()); ++i) {
            if (recipeInput.size() <= i) {
                if (input.get(i).m_41619_()) continue;
                return AbstractCraftActionContext.Result.FAIL;
            }
            if (input.size() <= i) {
                return AbstractCraftActionContext.Result.FAIL;
            }
            if (((GunSmithTableIngredient)recipeInput.get(i)).getIngredient().test(input.get(i))) continue;
            return AbstractCraftActionContext.Result.FAIL;
        }
        boolean allMatch = true;
        for (ItemStack i : input) {
            ItemStack extracted = InvUtil.tryExtractForCrafting((IItemHandler)inv, i);
            taken.add(extracted);
            if (extracted.m_41613_() == i.m_41613_()) continue;
            allMatch = false;
            break;
        }
        if (!allMatch) {
            for (ItemStack i : taken) {
                InvUtil.tryPlace((IItemHandler)inv, i);
            }
            return AbstractCraftActionContext.Result.FAIL;
        }
        ItemStack result = recipe.get().m_8043_(level.m_9598_());
        if (ItemStackUtil.isSameInCrafting(result, output.get(0))) {
            this.craftLayer.addCurrentStepPlacedCounts(0, result.m_41613_());
        }
        if ((maxCanPlace = InvUtil.maxCanPlace((IItemHandler)inv, result)) >= result.m_41613_()) {
            InvUtil.tryPlace((IItemHandler)inv, result);
            return AbstractCraftActionContext.Result.SUCCESS;
        }
        return AbstractCraftActionContext.Result.FAIL;
    }

    @Override
    public void stop() {
    }
}

