/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.data;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.world.item.ItemStack;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.InvConsumeSimulator;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;

public class CraftResultContext {
    List<CraftLayer> layers;
    InvConsumeSimulator consumer = new InvConsumeSimulator();
    List<Pair<ItemStack, Integer>> itemRemain;
    int slotConsume;

    public CraftResultContext(List<CraftLayer> layers) {
        this.layers = layers;
        this.calculate(Integer.MAX_VALUE);
        this.itemRemain = this.consumer.getRemain();
    }

    protected void calculate(int maxSlotConsume) {
        Optional<CraftGuideData> craftData;
        CraftLayer layer;
        this.consumer.clear();
        this.slotConsume = 0;
        boolean isFirst = true;
        for (int _i = 0; _i < this.layers.size(); ++_i) {
            layer = this.layers.get(_i);
            layer.getItems().forEach(i -> this.consumer.removeConsumeCount((ItemStack)i, i.m_41613_()));
            craftData = layer.getCraftData();
            if (craftData.isEmpty()) break;
            layer.getItems().forEach(i -> this.consumer.addConsumeCount((ItemStack)i, i.m_41613_()));
            craftData.get().getAllOutputItemsWithOptional().forEach(i -> this.consumer.addConsumeCount((ItemStack)i, i.m_41613_() * layer.getCount()));
            int currentMaxConsume = Math.max(this.slotConsume, this.consumer.getCurrentSlotConsume() + craftData.get().getExtraSlotConsume());
            craftData.get().getAllInputItems().forEach(i -> this.consumer.removeConsumeCount((ItemStack)i, i.m_41613_() * layer.getCount()));
            if (maxSlotConsume < currentMaxConsume && !isFirst) {
                this.consumer.clear();
                --_i;
                isFirst = true;
                continue;
            }
            isFirst = false;
            this.slotConsume = currentMaxConsume;
        }
        Iterator<CraftLayer> iterator = this.layers.iterator();
        while (iterator.hasNext() && !(craftData = (layer = iterator.next()).getCraftData()).isEmpty()) {
            craftData.get().getAllOutputItems().forEach(i -> this.consumer.addConsumeCount((ItemStack)i, i.m_41613_() * layer.getCount()));
            craftData.get().getAllInputItems().forEach(i -> this.consumer.addConsumeCount((ItemStack)i, i.m_41613_() * layer.getCount()));
            craftData.get().getAllInputItemsWithOptional().forEach(i -> this.consumer.removeConsumeCount((ItemStack)i, i.m_41613_() * layer.getCount()));
            craftData.get().getAllOutputItemsWithOptional().forEach(i -> this.consumer.removeConsumeCount((ItemStack)i, i.m_41613_() * layer.getCount()));
        }
    }

    public int getSlotConsume() {
        return this.slotConsume;
    }

    public void forEachRemaining(BiConsumer<ItemStack, Integer> consumer) {
        this.itemRemain.forEach(pair -> consumer.accept((ItemStack)pair.getA(), (Integer)pair.getB()));
    }

    public void splitTaskWith(int maxSlotConsume) {
        this.calculate(maxSlotConsume);
    }
}

