/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.debug;

import com.electronwill.nightconfig.toml.TomlParser;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.Logger;
import studio.fantasyit.maid_storage_manager.craft.algo.base.AbstractBiCraftGraph;
import studio.fantasyit.maid_storage_manager.craft.algo.base.CraftResultNode;
import studio.fantasyit.maid_storage_manager.craft.algo.base.node.CraftNode;
import studio.fantasyit.maid_storage_manager.craft.algo.base.node.ItemNode;
import studio.fantasyit.maid_storage_manager.craft.algo.base.node.Node;
import studio.fantasyit.maid_storage_manager.craft.algo.base.node.SimCraftNode;
import studio.fantasyit.maid_storage_manager.craft.algo.base.node.SimItemNode;
import studio.fantasyit.maid_storage_manager.craft.algo.graph.SimpleSearchGraph;
import studio.fantasyit.maid_storage_manager.craft.debug.CraftingDebugContext;

public class CraftingCalculationTester {
    public static void main(String[] args) throws IOException {
        CraftingCalculationTester.startTestFrom(args[0]);
    }

    public static void startTestFrom(String path) throws FileNotFoundException {
        Config.testLoad(new TomlParser().parse((Reader)new FileReader("./config/maid_storage_manager-common.toml")));
        Logger.info("Starting test from " + path, new Object[0]);
        CraftingDebugContext context = new CraftingDebugContext(false, "./logs/msm_crafting/");
        Logger.info("Debug log saved to: runs/logs/msm_crafting/" + context.id, new Object[0]);
        Gson gson = new GsonBuilder().create();
        JsonObject data = (JsonObject)gson.fromJson((Reader)new FileReader(path), JsonObject.class);
        JsonArray jsonElements = data.get("nodes").getAsJsonArray();
        SimpleSearchGraph graph = new SimpleSearchGraph(List.of(), List.of());
        context.convey(graph);
        for (int i = 0; i < jsonElements.size(); ++i) {
            JsonObject jsonObject = jsonElements.get(i).getAsJsonObject();
            if (jsonObject.get("type").getAsString().equals("item")) {
                SimItemNode itemNode = new SimItemNode(i, true, jsonObject.get("info").getAsString());
                itemNode.count = jsonObject.get("count").getAsInt();
                itemNode.crafted = jsonObject.get("crafted").getAsInt();
                itemNode.required = jsonObject.get("required").getAsInt();
                itemNode.isLoopedIngredient = jsonObject.get("isLoopedIngredient").getAsBoolean();
                itemNode.loopInputIngredientCount = jsonObject.get("loopInputIngredientCount").getAsInt();
                itemNode.singleTimeCount = jsonObject.get("singleTimeCount").getAsInt();
                graph.addNode(itemNode);
                continue;
            }
            if (!jsonObject.get("type").getAsString().equals("craft")) continue;
            ArrayList<Pair<Integer, Integer>> edges = new ArrayList<Pair<Integer, Integer>>();
            for (int j = 0; j < jsonObject.get("edges").getAsJsonArray().size(); ++j) {
                JsonObject edge = jsonObject.get("edges").getAsJsonArray().get(j).getAsJsonObject();
                edges.add(new Pair((Object)edge.get("id").getAsInt(), (Object)edge.get("weight").getAsInt()));
            }
            ArrayList<Pair<Integer, Integer>> edgesRev = new ArrayList<Pair<Integer, Integer>>();
            for (int j = 0; j < jsonObject.get("edgesRev").getAsJsonArray().size(); ++j) {
                JsonObject edge = jsonObject.get("edgesRev").getAsJsonArray().get(j).getAsJsonObject();
                edgesRev.add((Pair<Integer, Integer>)new Pair((Object)edge.get("id").getAsInt(), (Object)edge.get("weight").getAsInt()));
            }
            SimCraftNode craftNode = new SimCraftNode(i, true, jsonObject.get("info").getAsString(), edges, edgesRev);
            graph.addNode(craftNode);
        }
        graph.restoreCurrentAndStartContext(data.get("targetItemId").getAsInt(), data.get("targetItemCount").getAsInt());
        graph.buildGraphInstantly();
        while (!graph.process()) {
        }
        List<CraftResultNode> results = graph.getRawResults();
        Logger.info("Found %d results", results.size());
        for (CraftResultNode craftLayer : results) {
            Logger.info(" + > " + graph.getNode(craftLayer.index), new Object[0]);
        }
    }

    public static void exportTo(AbstractBiCraftGraph graph, ItemStack targetItem, int count, String path) {
        graph.restoreCurrent();
        graph.startContext(targetItem, count);
        graph.buildGraphInstantly();
        JsonArray jsonArray = new JsonArray();
        for (int i = 0; i < graph.getNodeCount(); ++i) {
            Node node = graph.getNode(i);
            JsonObject jsonObject = new JsonObject();
            if (node instanceof ItemNode) {
                ItemNode in = (ItemNode)node;
                jsonObject.addProperty("type", "item");
                jsonObject.addProperty("required", (Number)in.required);
                jsonObject.addProperty("crafted", (Number)in.crafted);
                jsonObject.addProperty("count", (Number)in.count);
                jsonObject.addProperty("isLoopedIngredient", Boolean.valueOf(in.isLoopedIngredient));
                jsonObject.addProperty("loopInputIngredientCount", (Number)in.loopInputIngredientCount);
                jsonObject.addProperty("singleTimeCount", (Number)in.singleTimeCount);
                jsonObject.addProperty("info", in.itemStack.m_41720_().toString());
            } else if (node instanceof CraftNode) {
                CraftNode cn = (CraftNode)node;
                jsonObject.addProperty("type", "craft");
                jsonObject.addProperty("scheduled", (Number)cn.scheduled);
                jsonObject.addProperty("hasLoopIngredient", Boolean.valueOf(cn.hasLoopIngredient));
                JsonArray edges = new JsonArray();
                cn.edges.forEach(e -> {
                    JsonObject edge = new JsonObject();
                    edge.addProperty("id", (Number)e.getA());
                    edge.addProperty("weight", (Number)e.getB());
                    edges.add((JsonElement)edge);
                });
                jsonObject.add("edges", (JsonElement)edges);
                JsonArray edgesRev = new JsonArray();
                cn.revEdges.forEach(e -> {
                    JsonObject edge = new JsonObject();
                    edge.addProperty("id", (Number)e.getA());
                    edge.addProperty("weight", (Number)e.getB());
                    edgesRev.add((JsonElement)edge);
                });
                jsonObject.add("edgesRev", (JsonElement)edgesRev);
                jsonObject.addProperty("info", cn.craftGuideData.toString());
            }
            jsonArray.add((JsonElement)jsonObject);
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("targetItemId", (Number)graph.getItemNode((ItemStack)targetItem).id);
        jsonObject.addProperty("targetItemCount", (Number)count);
        jsonObject.add("nodes", (JsonElement)jsonArray);
        try (FileWriter fileWriter = new FileWriter(path);){
            Gson gson = new GsonBuilder().create();
            gson.toJson((JsonElement)jsonObject, (Appendable)fileWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

