/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.type.base;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.config.ConfigTypes;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.MoveUtil;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;

public interface IAutoCraftGuideGenerator {
    @NotNull
    public ResourceLocation getType();

    default public boolean allowMultiPosition() {
        return false;
    }

    default public boolean canCacheGraph() {
        return true;
    }

    default public void init() {
    }

    default public boolean positionalAvailable(ServerLevel level, EntityMaid maid, BlockPos pos, MaidPathFindingBFS pathFinding) {
        if (StorageAccessUtil.getMarksWithSameContainer((Level)((ServerLevel)maid.m_9236_()), Target.virtual(pos, null)).stream().anyMatch(t -> ((ItemStack)t.getB()).m_150930_((Item)ItemRegistry.NO_ACCESS.get()))) {
            return false;
        }
        return !MoveUtil.getAllAvailablePosForTarget((ServerLevel)maid.m_9236_(), maid, pos, pathFinding).isEmpty();
    }

    public boolean isBlockValid(Level var1, BlockPos var2);

    public void generate(List<InventoryItem> var1, Level var2, BlockPos var3, ICachableGeneratorGraph var4, Map<ResourceLocation, List<BlockPos>> var5);

    public void onCache(RecipeManager var1);

    public Component getConfigName();

    default public List<ConfigTypes.ConfigType<?>> getConfigurations() {
        return List.of();
    }
}

