/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.type.botania;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonPickupItemAction;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonThrowItemAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.cache.RecipeIngredientCache;
import studio.fantasyit.maid_storage_manager.craft.generator.type.base.IAutoCraftGuideGenerator;
import studio.fantasyit.maid_storage_manager.craft.generator.util.GenerateIngredientUtil;
import studio.fantasyit.maid_storage_manager.craft.type.CommonType;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.storage.Target;
import vazkii.botania.api.recipe.ElvenTradeRecipe;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;

public class GeneratorBotaniaElven
implements IAutoCraftGuideGenerator {
    @Override
    @NotNull
    public ResourceLocation getType() {
        return ElvenTradeRecipe.TYPE_ID;
    }

    @Override
    public boolean isBlockValid(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60713_(BotaniaBlocks.alfPortal);
    }

    @Override
    public void generate(List<InventoryItem> inventory, Level level, BlockPos pos, ICachableGeneratorGraph graph, Map<ResourceLocation, List<BlockPos>> recognizedTypePositions) {
        level.m_7465_().m_44013_(BotaniaRecipeTypes.ELVEN_TRADE_TYPE).forEach(recipe -> {
            List<Integer> ingredientCounts = recipe.m_7527_().stream().map(t -> Arrays.stream(t.m_43908_()).findFirst().map(ItemStack::m_41613_).orElse(1)).toList();
            graph.addRecipe(recipe.m_6423_(), (List<Ingredient>)recipe.m_7527_(), ingredientCounts, recipe.getOutputs(), items -> {
                ArrayList<CraftGuideStepData> steps = new ArrayList<CraftGuideStepData>();
                GenerateIngredientUtil.each3items(items, t -> steps.add(new CraftGuideStepData(Target.virtual(pos, Direction.UP), (List<ItemStack>)t, List.of(), CommonThrowItemAction.TYPE)));
                GenerateIngredientUtil.each3items(recipe.getOutputs(), t -> steps.add(new CraftGuideStepData(Target.virtual(pos, Direction.UP), List.of(), recipe.getOutputs(), CommonPickupItemAction.TYPE)));
                return new CraftGuideData(steps, CommonType.TYPE);
            });
        });
    }

    @Override
    public void onCache(RecipeManager manager) {
        manager.m_44013_(BotaniaRecipeTypes.ELVEN_TRADE_TYPE).forEach(RecipeIngredientCache::addRecipeCache);
    }

    @Override
    public Component getConfigName() {
        return Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.botania.elven");
    }
}

