/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.request.ret;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.Map;
import java.util.Objects;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.debug.DebugData;
import studio.fantasyit.maid_storage_manager.entity.VirtualItemEntity;
import studio.fantasyit.maid_storage_manager.items.RequestListItem;
import studio.fantasyit.maid_storage_manager.maid.ChatTexts;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.maid.memory.RequestProgressMemory;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.StorageVisitLock;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageContext;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageInsertableContext;
import studio.fantasyit.maid_storage_manager.util.BehaviorBreath;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.MathUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.RequestItemUtil;

public class RequestRetBehavior
extends Behavior<EntityMaid> {
    private final BehaviorBreath breath = new BehaviorBreath();
    @Nullable
    IStorageContext context;
    int currentSlot = 0;
    private Target target;
    private Entity targetEntity;
    private boolean targetEntityReady = false;
    private VirtualItemEntity thrown;
    boolean inCrafting = false;
    private StorageVisitLock.LockContext lock = StorageVisitLock.DUMMY;

    public RequestRetBehavior() {
        super(Map.of());
    }

    protected boolean checkExtraStartConditions(ServerLevel p_22538_, EntityMaid maid) {
        if (MemoryUtil.getCurrentlyWorking(maid) != ScheduleBehavior.Schedule.REQUEST) {
            return false;
        }
        if (MemoryUtil.isWorking(maid)) {
            return false;
        }
        if (!MemoryUtil.getRequestProgress(maid).isReturning()) {
            return false;
        }
        return Conditions.hasReachedValidTargetOrReset(maid);
    }

    protected boolean canStillUse(ServerLevel p_22545_, EntityMaid maid, long p_22547_) {
        if (this.thrown != null) {
            return true;
        }
        if (this.currentSlot >= maid.getAvailableInv(false).getSlots()) {
            return false;
        }
        return this.context != null && !this.context.isDone() || this.targetEntity != null;
    }

    protected void start(ServerLevel level, EntityMaid maid, long p_22542_) {
        MemoryUtil.setWorking(maid, true);
        this.lock = StorageVisitLock.DUMMY;
        this.context = null;
        this.targetEntity = null;
        this.thrown = null;
        RequestProgressMemory requestProgress = MemoryUtil.getRequestProgress(maid);
        if (requestProgress.isReturning()) {
            Entity entity;
            if (requestProgress.hasTarget()) {
                requestProgress.addTries();
                this.target = requestProgress.getTarget();
                this.context = Objects.requireNonNull(MaidStorage.getInstance().getStorage(this.target.getType())).onStartPlace(level, maid, this.target);
                if (this.context != null) {
                    this.context.start(maid, level, this.target);
                }
                this.lock = StorageVisitLock.getWriteLock(this.target, maid);
            } else if (requestProgress.getTargetEntityUUID().isPresent() && (entity = (this.targetEntity = level.m_8791_(requestProgress.getTargetEntityUUID().get()))) instanceof EntityMaid) {
                EntityMaid m = (EntityMaid)entity;
                this.targetEntityReady = false;
                this.tryReadyMaid(m, maid);
            }
        }
        this.currentSlot = 0;
        this.inCrafting = MemoryUtil.getCrafting(maid).hasPlan();
    }

    protected boolean tryReadyMaid(EntityMaid m, EntityMaid maid) {
        if (this.targetEntityReady) {
            return true;
        }
        if (MemoryUtil.isWorking(m) && !MemoryUtil.isParallelWorking(m)) {
            return false;
        }
        MemoryUtil.joinAndStartParallelWorking(m);
        m.m_21573_().m_26573_();
        MemoryUtil.setTarget(m, (Entity)m, (float)Config.collectSpeed);
        this.targetEntityReady = true;
        InvUtil.mergeSameStack((IItemHandler)m.getAvailableInv(true));
        return true;
    }

    protected void tick(ServerLevel p_22551_, EntityMaid maid, long p_22553_) {
        if (!this.breath.breathTick(maid)) {
            return;
        }
        super.m_6725_(p_22551_, (LivingEntity)maid, p_22553_);
        if (this.context != null) {
            this.tickStorageContext(maid);
        }
        if (this.targetEntity != null) {
            this.tickTargetEntity(maid);
        }
    }

    private void tickTargetEntity(EntityMaid maid) {
        Entity entity = this.targetEntity;
        if (entity instanceof EntityMaid) {
            EntityMaid m = (EntityMaid)entity;
            if (!this.tryReadyMaid(m, maid)) {
                return;
            }
            MemoryUtil.setLookAt(m, (Entity)maid);
        }
        if (this.thrown != null) {
            entity = this.targetEntity;
            if (entity instanceof EntityMaid) {
                EntityMaid targetMaid = (EntityMaid)entity;
                DebugData.invChange(DebugData.InvChange.IN, targetMaid, this.thrown.getItem());
                InvUtil.pickUpVirtual(targetMaid, this.thrown);
                DebugData.invChange(DebugData.InvChange.CURRENT, targetMaid, ItemStack.f_41583_);
                if (!this.thrown.m_6084_()) {
                    this.thrown = null;
                }
            } else {
                this.thrown = null;
            }
            this.breath.reset();
            return;
        }
        CombinedInvWrapper inv = maid.getAvailableInv(false);
        Vec3 targetDir = MathUtil.getFromToWithFriction((Entity)maid, this.targetEntity.m_20318_(0.0f));
        for (int i = 0; i < 5 && this.targetEntity != null && inv.getSlots() > this.currentSlot; ++i) {
            @NotNull ItemStack item = inv.getStackInSlot(this.currentSlot++);
            int restCount = RequestListItem.updateStored(maid.m_21205_(), item, false, this.inCrafting);
            ItemStack toThrowStack = item.m_41777_();
            toThrowStack.m_41774_(restCount);
            if (toThrowStack.m_41619_()) continue;
            item.m_41764_(restCount);
            if (this.targetEntity instanceof EntityMaid) {
                this.thrown = InvUtil.throwItemVirtual(maid, toThrowStack, targetDir);
                DebugData.invChange(DebugData.InvChange.OUT, maid, toThrowStack);
            } else {
                InvUtil.throwItem(maid, toThrowStack, targetDir, true);
            }
            inv.setStackInSlot(this.currentSlot - 1, item);
            break;
        }
    }

    private void tickStorageContext(EntityMaid maid) {
        if (!this.lock.checkAndTryGrantLock()) {
            return;
        }
        CombinedInvWrapper availableInv = maid.getAvailableInv(true);
        for (int i = 0; i < 5 && this.currentSlot < availableInv.getSlots(); ++i) {
            if (!availableInv.getStackInSlot(this.currentSlot).m_41619_()) continue;
            ++this.currentSlot;
        }
        if (availableInv.getStackInSlot(this.currentSlot) == maid.m_21205_()) {
            ++this.currentSlot;
        }
        if (this.currentSlot < availableInv.getSlots()) {
            IStorageContext iStorageContext;
            ItemStack stack = availableInv.getStackInSlot(this.currentSlot);
            if (!stack.m_41619_() && (iStorageContext = this.context) instanceof IStorageInsertableContext) {
                IStorageInsertableContext isic = (IStorageInsertableContext)iStorageContext;
                int i = RequestListItem.updateStored(maid.m_21205_(), stack, true, this.inCrafting);
                int canStoreCount = stack.m_41613_() - i;
                ItemStack notInserted = isic.insert(stack.m_255036_(canStoreCount));
                ItemStack toStoreItemStack = stack.m_255036_(canStoreCount - notInserted.m_41613_());
                RequestListItem.updateStored(maid.m_21205_(), toStoreItemStack, false, this.inCrafting);
                availableInv.setStackInSlot(this.currentSlot, stack.m_255036_(stack.m_41613_() - toStoreItemStack.m_41613_()));
            }
            ++this.currentSlot;
        }
    }

    protected void stop(@NotNull ServerLevel level, @NotNull EntityMaid maid, long p_22550_) {
        Entity entity;
        this.lock.release();
        MemoryUtil.setWorking(maid, false);
        super.m_6732_(level, (LivingEntity)maid, p_22550_);
        if (this.context != null) {
            this.context.finish();
        }
        if ((entity = this.targetEntity) instanceof EntityMaid) {
            EntityMaid m = (EntityMaid)entity;
            MemoryUtil.clearTarget(m);
            MemoryUtil.clearPickUpItemTemp(m);
            MemoryUtil.leaveParallelWorking(m);
        }
        if (MemoryUtil.getCrafting(maid).hasPlan()) {
            MemoryUtil.getRequestProgress(maid).setReturn(false);
            MemoryUtil.getRequestProgress(maid).setTryCrafting(true);
            MemoryUtil.getRequestProgress(maid).clearTarget();
            MemoryUtil.getCrafting(maid).clearTarget();
            MemoryUtil.getCrafting(maid).plan().checkAndSwitchGroup(maid);
            MemoryUtil.clearTarget(maid);
            return;
        }
        if ((Conditions.listAllStored(maid) || Conditions.triesReach(maid)) && Conditions.listAllDone(maid)) {
            if (RequestListItem.isAllSuccess(maid.m_21205_())) {
                ChatTexts.send(maid, "chat_bubbles.maid_storage_manager.request_finish");
            } else {
                ChatTexts.send(maid, "chat_bubbles.maid_storage_manager.request_fail");
            }
            RequestItemUtil.stopJobAndStoreOrThrowItem(maid, this.context, this.targetEntity);
            if (this.target != null) {
                MemoryUtil.setInteractPos(maid, this.target.getPos().m_7494_());
            }
        }
        RequestListItem.updateCollectedNotStored(maid.m_21205_(), (IItemHandler)maid.getAvailableInv(false));
        MemoryUtil.getRequestProgress(maid).setReturn(false);
        MemoryUtil.getRequestProgress(maid).clearTarget();
        MemoryUtil.getCrafting(maid).clearTarget();
        MemoryUtil.clearTarget(maid);
        if (!InvUtil.hasAnyFree((IItemHandler)maid.getAvailableInv(false))) {
            RequestItemUtil.stopJobAndStoreOrThrowItem(maid, null, null);
        }
    }

    protected boolean m_7773_(long p_22537_) {
        return false;
    }
}

