/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.view;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.advancement.AdvancementTypes;
import studio.fantasyit.maid_storage_manager.items.WorkCardItem;
import studio.fantasyit.maid_storage_manager.maid.ChatTexts;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.StorageVisitLock;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.storage.base.IFilterable;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageContext;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageInteractContext;
import studio.fantasyit.maid_storage_manager.util.BehaviorBreath;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;

public class ViewBehavior
extends MaidCheckRateTask {
    private final BehaviorBreath breath = new BehaviorBreath();
    private IStorageContext context = null;
    Target target = null;
    List<ItemStack> mismatchFilter = new ArrayList<ItemStack>();
    boolean shouldSeekForWorkMeal = false;
    MutableObject<ItemStack> workMeal = new MutableObject(null);
    int holdStamp = -1;
    StorageVisitLock.LockContext lock;

    public ViewBehavior() {
        super(Map.of());
        this.setMaxCheckRate(5);
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel worldIn, @NotNull EntityMaid owner) {
        if (!super.checkExtraStartConditions(worldIn, owner)) {
            return false;
        }
        if (MemoryUtil.getCurrentlyWorking(owner) != ScheduleBehavior.Schedule.VIEW) {
            return false;
        }
        if (!MemoryUtil.getViewedInventory(owner).hasTarget()) {
            return false;
        }
        return Conditions.hasReachedValidTargetOrReset(owner);
    }

    protected boolean canStillUse(ServerLevel p_22545_, EntityMaid maid, long p_22547_) {
        return this.context != null && !this.context.isDone();
    }

    protected void start(@NotNull ServerLevel level, @NotNull EntityMaid maid, long p_22542_) {
        this.lock = StorageVisitLock.DUMMY;
        if (!MemoryUtil.getViewedInventory(maid).hasTarget()) {
            return;
        }
        MemoryUtil.setWorking(maid, true);
        this.target = MemoryUtil.getViewedInventory(maid).getTarget();
        MemoryUtil.getViewedInventory(maid).resetViewedInvForPos(this.target);
        StorageAccessUtil.checkNearByContainers((Level)level, this.target.getPos(), pos -> MemoryUtil.getViewedInventory(maid).resetViewedInvForPosAsRemoved(this.target.sameType((BlockPos)pos, null)));
        MemoryUtil.getViewedInventory(maid).lockAmbitiousPos(level, this.target);
        MemoryUtil.getViewedInventory(maid).setViewing(true);
        this.context = MaidStorage.getInstance().getStorage(this.target.type).onStartView(level, maid, this.target);
        if (this.context != null) {
            this.context.start(maid, level, this.target);
        }
        this.mismatchFilter.clear();
        this.workMeal = new MutableObject(null);
        this.shouldSeekForWorkMeal = MemoryUtil.getMeal(maid).shouldTakeMeal(maid);
        AdvancementTypes.triggerForMaid(maid, "view");
        this.holdStamp = level.m_7654_().m_129921_();
        this.lock = StorageVisitLock.getReadLock(this.target, maid);
    }

    protected void tick(ServerLevel p_22551_, EntityMaid maid, long p_22553_) {
        if (!this.lock.checkAndTryGrantLock()) {
            return;
        }
        if (!this.breath.breathTick(maid)) {
            return;
        }
        super.m_6725_(p_22551_, (LivingEntity)maid, p_22553_);
        IStorageContext iStorageContext = this.context;
        if (iStorageContext instanceof IStorageInteractContext) {
            IStorageInteractContext isic = (IStorageInteractContext)iStorageContext;
            isic.tick(itemStack -> {
                IFilterable filter;
                if (isic instanceof IFilterable && !(filter = (IFilterable)((Object)isic)).isAvailable((ItemStack)itemStack)) {
                    this.mismatchFilter.add((ItemStack)itemStack);
                }
                if (this.shouldSeekForWorkMeal && MemoryUtil.getMeal(maid).isWorkMeal(maid, (ItemStack)itemStack)) {
                    this.workMeal.setValue(itemStack);
                }
                MemoryUtil.getViewedInventory(maid).addItem(this.target, (ItemStack)itemStack);
                return itemStack;
            });
        }
    }

    protected void stop(ServerLevel level, EntityMaid maid, long p_22550_) {
        this.lock.release();
        MemoryUtil.setWorking(maid, false);
        if (this.context != null) {
            MemoryUtil.getViewedInventory(maid).addVisitedPos(this.target);
            StorageAccessUtil.checkNearByContainers((Level)level, this.target.getPos(), pos -> MemoryUtil.getViewedInventory(maid).addVisitedPos(this.target.sameType((BlockPos)pos, null)));
            MemoryUtil.getViewedInventory(maid).clearTarget();
            this.context.finish();
        }
        MemoryUtil.getViewedInventory(maid).setViewing(false);
        if (this.target != null) {
            WorkCardItem.syncStorageOn(maid, this.target, this.holdStamp);
            MemoryUtil.getViewedInventory(maid).clearLock();
        }
        MemoryUtil.clearTarget(maid);
        LinkedList<Target> markChanged = MemoryUtil.getViewedInventory(maid).getMarkChanged();
        if (!markChanged.isEmpty() && markChanged.peek().equals(this.target)) {
            markChanged.poll();
        }
        if (!this.mismatchFilter.isEmpty()) {
            ChatTexts.send(maid, "chat_bubbles.maid_storage_manager.resort");
            AdvancementTypes.triggerForMaid(maid, "resort");
            MemoryUtil.getResorting(maid).setNeedToResort(this.mismatchFilter);
            MemoryUtil.getResorting(maid).setTarget(this.target);
            MemoryUtil.getResorting(maid).addVisitedPos(this.target);
            StorageAccessUtil.checkNearByContainers((Level)level, this.target.getPos(), pos -> MemoryUtil.getResorting(maid).addVisitedPos(this.target.sameType((BlockPos)pos, null)));
        } else if (this.workMeal.getValue() != null) {
            MemoryUtil.getMeal(maid).setCheckItem((ItemStack)this.workMeal.getValue());
            MemoryUtil.getMeal(maid).setTarget(this.target);
        }
    }

    protected boolean m_7773_(long p_22537_) {
        return false;
    }
}

