/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.view;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.advancement.AdvancementTypes;
import studio.fantasyit.maid_storage_manager.capability.InventoryListDataProvider;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.items.WrittenInvListItem;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.MathUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;

public class WriteInventoryListBehavior
extends Behavior<EntityMaid> {
    public WriteInventoryListBehavior() {
        super(Map.of());
    }

    protected boolean checkExtraStartConditions(ServerLevel p_22538_, @NotNull EntityMaid maid) {
        CombinedInvWrapper availableInv = maid.getAvailableInv(true);
        for (int i = 0; i < availableInv.getSlots(); ++i) {
            if (!availableInv.getStackInSlot(i).m_150930_((Item)ItemRegistry.INVENTORY_LIST.get())) continue;
            return true;
        }
        return false;
    }

    protected void start(@NotNull ServerLevel level, EntityMaid maid, long p_22542_) {
        CombinedInvWrapper availableInv = maid.getAvailableInv(true);
        for (int i = 0; i < availableInv.getSlots(); ++i) {
            if (!availableInv.getStackInSlot(i).m_150930_((Item)ItemRegistry.INVENTORY_LIST.get())) continue;
            ItemStack itemStack = availableInv.extractItem(i, 1, false);
            if (!itemStack.m_41782_() || !itemStack.m_41783_().m_128441_("uuid")) break;
            level.getCapability(InventoryListDataProvider.INVENTORY_LIST_DATA_CAPABILITY).ifPresent(inventoryListData -> inventoryListData.remove(itemStack.m_41783_().m_128342_("uuid")));
            break;
        }
        ItemStack item = ((Item)ItemRegistry.WRITTEN_INVENTORY_LIST.get()).m_7968_().m_255036_(1);
        UUID uuid = UUID.randomUUID();
        List<InventoryItem> flatten = MemoryUtil.getViewedInventory(maid).flatten();
        level.getCapability(InventoryListDataProvider.INVENTORY_LIST_DATA_CAPABILITY).ifPresent(inventoryListData -> inventoryListData.addWithCraftable(uuid, flatten));
        CompoundTag tag = item.m_41784_();
        tag.m_128362_("uuid", uuid);
        tag.m_128359_("author", maid.m_7755_().getString());
        tag.m_128356_("time", level.m_46468_());
        item.m_41751_(tag);
        LivingEntity livingEntity = maid.m_269323_();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            double dmg = Config.invListDamageMin + Math.min(Config.invListDamageMax, Config.invListDamageFactor * (double)flatten.size());
            ((WrittenInvListItem)((Object)ItemRegistry.WRITTEN_INVENTORY_LIST.get())).setAttributes(item, dmg - player.m_21172_(Attributes.f_22281_), Config.invListDamageAttackSpd - player.m_21172_(Attributes.f_22283_));
            InvUtil.throwItem(maid, item, MathUtil.getFromToWithFriction((Entity)maid, player.m_20182_()));
        } else {
            InvUtil.throwItem(maid, item);
        }
        AdvancementTypes.triggerForMaid(maid, "storage_list");
    }
}

