/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.menu.craft.tacz;

import com.tacz.guns.crafting.GunSmithTableIngredient;
import com.tacz.guns.crafting.GunSmithTableRecipe;
import com.tacz.guns.init.ModRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.craft.context.special.TaczRecipeAction;
import studio.fantasyit.maid_storage_manager.integration.tacz.TaczRecipe;
import studio.fantasyit.maid_storage_manager.menu.container.CountSlot;
import studio.fantasyit.maid_storage_manager.menu.container.FilterSlot;
import studio.fantasyit.maid_storage_manager.menu.craft.base.AbstractCraftMenu;
import studio.fantasyit.maid_storage_manager.menu.craft.base.ICraftGuiPacketReceiver;
import studio.fantasyit.maid_storage_manager.network.CraftGuideGuiPacket;
import studio.fantasyit.maid_storage_manager.registry.GuiRegistry;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class TaczCraftMenu
extends AbstractCraftMenu<TaczCraftMenu> {
    private final List<Pair<ItemStack, String>> taczRecipes = new ArrayList<Pair<ItemStack, String>>();
    GunSmithTableRecipe recipe = null;
    ICraftGuiPacketReceiver screenListener;

    public TaczCraftMenu(int p_38852_, Player player) {
        super((MenuType)GuiRegistry.CRAFT_GUIDE_MENU_TACZ.get(), p_38852_, player);
        ResourceLocation blockId = TaczRecipe.getBlockId(player.m_9236_(), this.stepDataContainer.step.storage.pos);
        List<GunSmithTableRecipe> allRecipesFor = TaczRecipe.getAllRecipesForBlockId(player.m_9236_(), blockId);
        RegistryAccess registryAccess = player.m_9236_().m_9598_();
        allRecipesFor.forEach(recipe -> this.taczRecipes.add((Pair<ItemStack, String>)new Pair((Object)recipe.m_8043_(registryAccess), (Object)recipe.m_6423_().toString())));
    }

    public void setScreenListener(ICraftGuiPacketReceiver screenListener) {
        this.screenListener = screenListener;
    }

    @Override
    protected void addFilterSlots() {
        int x = 112;
        for (int j = 0; j < 2; ++j) {
            int y = 24;
            for (int i = 0; i < 5; ++i) {
                Slot slot = this.m_38897_(new FilterSlot(this.stepDataContainer, i * 2 + j, x, y));
                int index = i * 2 + j;
                this.setSlotFilter(slot, (ItemStack itemStack) -> {
                    if (itemStack.m_41619_()) {
                        return true;
                    }
                    if (this.recipe == null) {
                        return false;
                    }
                    if (this.recipe.getInputs().size() <= index) {
                        return false;
                    }
                    return ((GunSmithTableIngredient)this.recipe.getInputs().get(index)).getIngredient().test(itemStack);
                });
                y += 18;
            }
            x += 20;
        }
        FilterSlot filterSlot = new FilterSlot(this.stepDataContainer, 10, 0, 0);
        this.m_38897_(filterSlot);
        filterSlot.setActive(false);
    }

    @Override
    protected void addSpecialSlots() {
        for (int i = 0; i < 11; ++i) {
            this.m_38895_(new CountSlot(this.stepDataContainer.getCountMutable(i), this.stepDataContainer));
        }
    }

    @Override
    public void handleGuiPacket(CraftGuideGuiPacket.Type type, int key, int value, @Nullable CompoundTag data) {
        switch (type) {
            case OPTION: {
                if (data == null) break;
                String sv = CraftGuideGuiPacket.getStringFrom(data);
                this.stepDataContainer.step.setOptionValue(this.stepDataContainer.step.actionType.options().get(key), sv);
                this.save();
                break;
            }
            case SET_ITEM: {
                if (data == null) break;
                this.m_38853_(key).m_5852_(ItemStackUtil.parseStack(data));
                this.save();
            }
        }
    }

    @Override
    public void recalculateRecipe() {
        String blockId = this.stepDataContainer.step.getOptionValue(TaczRecipeAction.OPTION_TACZ_BLOCK_ID);
        String recipeId = this.stepDataContainer.step.getOptionValue(TaczRecipeAction.OPTION_TACZ_RECIPE_ID);
        Level level = this.player.m_9236_();
        List allRecipesFor = level.m_7465_().m_44013_((RecipeType)ModRecipe.GUN_SMITH_TABLE_CRAFTING.get());
        GunSmithTableRecipe recipe = allRecipesFor.stream().filter(r -> r.m_6423_().toString().equals(recipeId)).findFirst().orElse(null);
        ResourceLocation realBlockId = TaczRecipe.getBlockId(level, this.stepDataContainer.step.storage.pos);
        if (!realBlockId.toString().equals(blockId)) {
            recipe = null;
        }
        this.recipe = recipe;
        if (recipe != null) {
            List inputs = recipe.getInputs();
            for (int i = 0; i < this.stepDataContainer.inputCount; ++i) {
                if (i >= inputs.size()) {
                    this.stepDataContainer.setItemNoTrigger(i, ItemStack.f_41583_);
                    continue;
                }
                if (this.stepDataContainer.m_8020_(i).m_41619_() && ((GunSmithTableIngredient)inputs.get(i)).getIngredient().m_43908_().length > 0) {
                    this.stepDataContainer.setItemNoTrigger(i, ((GunSmithTableIngredient)inputs.get(i)).getIngredient().m_43908_()[0]);
                    this.stepDataContainer.setCount(i, ((GunSmithTableIngredient)inputs.get(i)).getCount());
                    continue;
                }
                if (!((GunSmithTableIngredient)inputs.get(i)).getIngredient().test(this.stepDataContainer.m_8020_(i))) {
                    this.stepDataContainer.setItemNoTrigger(i, ((GunSmithTableIngredient)inputs.get(i)).getIngredient().m_43908_()[0]);
                    this.stepDataContainer.setCount(i, ((GunSmithTableIngredient)inputs.get(i)).getCount());
                    continue;
                }
                if (this.stepDataContainer.getCount(i) == ((GunSmithTableIngredient)inputs.get(i)).getCount()) continue;
                this.stepDataContainer.setCount(i, ((GunSmithTableIngredient)inputs.get(i)).getCount());
            }
            ItemStack output = recipe.getResult().getResult();
            this.stepDataContainer.setItemNoTrigger(this.stepDataContainer.inputCount, output);
            this.stepDataContainer.setCount(this.stepDataContainer.inputCount, output.m_41613_());
        } else {
            for (int i = 0; i < this.stepDataContainer.inputCount; ++i) {
                this.stepDataContainer.setItemNoTrigger(i, ItemStack.f_41583_);
            }
            this.stepDataContainer.setItemNoTrigger(this.stepDataContainer.inputCount, ItemStack.f_41583_);
            this.stepDataContainer.setCount(this.stepDataContainer.inputCount, 1);
        }
    }

    public ResourceLocation getBlockId() {
        return TaczRecipe.getBlockId(this.player.m_9236_(), this.stepDataContainer.step.storage.pos);
    }

    public String getRecipeId() {
        return this.stepDataContainer.step.getOptionValue(TaczRecipeAction.OPTION_TACZ_RECIPE_ID);
    }

    public void getAllRecipes(List<Pair<ItemStack, String>> taczRecipes) {
        taczRecipes.addAll(this.taczRecipes);
    }
}

