/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.util;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PosUtil {
    @Nullable
    public static <T> T findInUpperSquare(BlockPos pos, int dx, int dy, int dz, Function<BlockPos, @Nullable T> consumer) {
        for (int i = -dx; i <= dx; ++i) {
            for (int j = 0; j <= dy; ++j) {
                for (int k = -dz; k <= dz; ++k) {
                    BlockPos pos1 = pos.m_7918_(i, j, k);
                    T t = consumer.apply(pos1);
                    if (t == null) continue;
                    return t;
                }
            }
        }
        return null;
    }

    @Nullable
    public static <T> T findAround(BlockPos pos, Function<BlockPos, @Nullable T> consumer) {
        T tmp = consumer.apply(pos);
        if (tmp != null) {
            return tmp;
        }
        tmp = consumer.apply(pos.m_122012_());
        if (tmp != null) {
            return tmp;
        }
        tmp = consumer.apply(pos.m_122029_());
        if (tmp != null) {
            return tmp;
        }
        tmp = consumer.apply(pos.m_122019_());
        if (tmp != null) {
            return tmp;
        }
        tmp = consumer.apply(pos.m_122024_());
        if (tmp != null) {
            return tmp;
        }
        return null;
    }

    @Nullable
    public static <T> T findAroundUpAndDown(BlockPos pos, Function<BlockPos, @Nullable T> consumer) {
        return PosUtil.findAroundUpAndDown(pos, consumer, 4);
    }

    @Nullable
    public static <T> T findAroundUpAndDown(BlockPos pos, Function<BlockPos, @Nullable T> consumer, int depth) {
        T tmp;
        for (int i = 0; i < depth * 2; ++i) {
            tmp = consumer.apply(pos);
            if (tmp != null) {
                return tmp;
            }
            tmp = consumer.apply(pos.m_122012_());
            if (tmp != null) {
                return tmp;
            }
            tmp = consumer.apply(pos.m_122029_());
            if (tmp != null) {
                return tmp;
            }
            tmp = consumer.apply(pos.m_122019_());
            if (tmp != null) {
                return tmp;
            }
            tmp = consumer.apply(pos.m_122024_());
            if (tmp != null) {
                return tmp;
            }
            pos = i % 2 != 0 ? pos.m_6630_(i + 1) : pos.m_6625_(i + 1);
        }
        tmp = consumer.apply(pos);
        if (tmp != null) {
            return tmp;
        }
        return null;
    }

    @NotNull
    public static <T> List<T> gatherAroundUpAndDown(BlockPos pos, Function<BlockPos, @Nullable T> consumer) {
        return PosUtil.gatherAroundUpAndDown(pos, consumer, 4);
    }

    @NotNull
    public static <T> List<T> gatherAroundUpAndDown(BlockPos pos, Function<BlockPos, @Nullable T> consumer, int depth) {
        T tmp;
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < depth * 2; ++i) {
            tmp = consumer.apply(pos);
            if (tmp != null) {
                result.add(tmp);
            }
            if ((tmp = consumer.apply(pos.m_122012_())) != null) {
                result.add(tmp);
            }
            if ((tmp = consumer.apply(pos.m_122029_())) != null) {
                result.add(tmp);
            }
            if ((tmp = consumer.apply(pos.m_122019_())) != null) {
                result.add(tmp);
            }
            if ((tmp = consumer.apply(pos.m_122024_())) != null) {
                result.add(tmp);
            }
            pos = i % 2 != 0 ? pos.m_6630_(i + 1) : pos.m_6625_(i + 1);
        }
        tmp = consumer.apply(pos);
        if (tmp != null) {
            result.add(tmp);
        }
        return result;
    }

    @NotNull
    public static BlockPos getEntityPos(Level level, @NotNull BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity == null) {
            return pos;
        }
        return blockEntity.m_58899_();
    }

    protected static boolean isEmptyBlockPos(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60742_((BlockGetter)level, pos, CollisionContext.m_82749_()).m_83281_();
    }

    public static boolean isSafePos(Level level, BlockPos pos) {
        return PosUtil.isEmptyBlockPos(level, pos) && PosUtil.isEmptyBlockPos(level, pos.m_7494_()) && !PosUtil.isEmptyBlockPos(level, pos.m_7495_());
    }

    public static boolean hasSightLineOnAnySurface(Level level, Vec3 pos1, BlockPos pos2) {
        for (Direction direction : Direction.values()) {
            BlockHitResult result = level.m_45547_(new ClipContext(pos1, pos2.m_252807_().m_231075_(direction, 0.4), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
            if (result.m_6662_() != HitResult.Type.BLOCK || !result.m_82425_().equals((Object)pos2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBetween(int x1, int x2, int x3) {
        return Math.min(x1, x2) <= x3 && x3 <= Math.max(x1, x2);
    }

    public static boolean isBetween(BlockPos pos1, BlockPos pos2, BlockPos pos3) {
        return PosUtil.isBetween(pos1.m_123341_(), pos2.m_123341_(), pos3.m_123341_()) && PosUtil.isBetween(pos1.m_123342_(), pos2.m_123342_(), pos3.m_123342_()) && PosUtil.isBetween(pos1.m_123343_(), pos2.m_123343_(), pos3.m_123343_());
    }

    public static boolean canTouch(ServerLevel serverLevel, BlockPos standPos, BlockPos touchPos) {
        if (standPos.equals((Object)touchPos)) {
            return true;
        }
        int xOffset = touchPos.m_123341_() > standPos.m_123341_() ? 1 : -1;
        int zOffset = touchPos.m_123343_() > standPos.m_123343_() ? 1 : -1;
        int yOffset = touchPos.m_123342_() > standPos.m_123342_() ? 1 : -1;
        HashSet<BlockPos> vis = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.add(standPos);
        while (!queue.isEmpty()) {
            BlockPos zPos;
            BlockPos yPos;
            BlockPos poll = (BlockPos)queue.poll();
            if (poll.m_123333_((Vec3i)standPos) > 5) continue;
            BlockPos xPos = poll.m_7918_(xOffset, 0, 0);
            if (xPos.equals((Object)touchPos)) {
                return true;
            }
            if (!vis.contains(xPos) && PosUtil.isBetween(standPos, touchPos, xPos) && PosUtil.isTreatedAsEmpty(serverLevel, xPos)) {
                vis.add(xPos);
                queue.add(xPos);
            }
            if ((yPos = poll.m_7918_(0, yOffset, 0)).equals((Object)touchPos)) {
                return true;
            }
            if (!vis.contains(yPos) && PosUtil.isBetween(standPos, touchPos, yPos) && PosUtil.isTreatedAsEmpty(serverLevel, yPos)) {
                vis.add(yPos);
                queue.add(yPos);
            }
            if ((zPos = poll.m_7918_(0, 0, zOffset)).equals((Object)touchPos)) {
                return true;
            }
            if (vis.contains(zPos) || !PosUtil.isBetween(standPos, touchPos, zPos) || !PosUtil.isTreatedAsEmpty(serverLevel, zPos)) continue;
            vis.add(zPos);
            queue.add(zPos);
        }
        return false;
    }

    private static boolean isTreatedAsEmpty(ServerLevel serverLevel, BlockPos pos) {
        VoxelShape collisionShape = serverLevel.m_8055_(pos).m_60812_((BlockGetter)serverLevel, pos);
        if (collisionShape.m_83281_()) {
            return true;
        }
        return collisionShape.m_83215_().m_82309_() < 0.16;
    }

    public static void walkThroughWithinEyesight(ServerLevel level, EntityMaid origin, AABB aabb, Consumer<BlockPos> consumer) {
        BlockPos.m_121921_((AABB)aabb).filter(pos -> PosUtil.canTouch(level, origin.m_20183_().m_7494_(), pos)).forEach(consumer);
    }
}

