/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import studio.fantasyit.maid_storage_manager.Logger;

public class ThreadingUtil {
    public static final ExecutorService pool = Executors.newFixedThreadPool(8);
    public static final ExecutorService watchPool = Executors.newFixedThreadPool(8);

    public static Future<?> run(Runnable runnable) {
        Future<?> submitted = pool.submit(runnable);
        watchPool.submit(() -> {
            int i = 0;
            while (!submitted.isDone()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
                finally {
                    if (++i <= 30) continue;
                    Logger.warn("Crafting task timeout after 30s", new Object[0]);
                    submitted.cancel(true);
                }
            }
        });
        return submitted;
    }
}

