/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.block;

import com.fruitstack.fruitstack.common.block.LifeFarmLandBlock;
import com.fruitstack.fruitstack.common.registry.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class CorruptSoilFarmLandBlock
extends FarmBlock {
    public CorruptSoilFarmLandBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private static boolean hasWater(LevelReader level, BlockPos pos) {
        for (BlockPos nearbyPos : BlockPos.betweenClosed((BlockPos)pos.offset(-4, 0, -4), (BlockPos)pos.offset(4, 1, 4))) {
            if (!level.getFluidState(nearbyPos).is(FluidTags.WATER)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)level, (BlockPos)pos);
    }

    public static void turnToRichSoil(BlockState state, Level level, BlockPos pos) {
        level.setBlockAndUpdate(pos, CorruptSoilFarmLandBlock.pushEntitiesUp((BlockState)state, (BlockState)((Block)ModBlocks.CORRUPT_SOIL.get()).defaultBlockState(), (LevelAccessor)level, (BlockPos)pos));
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState aboveState = level.getBlockState(pos.above());
        return super.canSurvive(state, level, pos) || aboveState.getBlock() instanceof StemGrownBlock;
    }

    public boolean isFertile(BlockState state, BlockGetter world, BlockPos pos) {
        if (state.is((Block)ModBlocks.CORRUPT_SOIL_FARMLAND.get())) {
            return (Integer)state.getValue((Property)LifeFarmLandBlock.MOISTURE) > 0;
        }
        return false;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            CorruptSoilFarmLandBlock.turnToRichSoil(state, (Level)level, pos);
        }
    }

    private static boolean isNearWater(LevelReader p_53259_, BlockPos p_53260_) {
        for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)p_53260_.offset(-4, 0, -4), (BlockPos)p_53260_.offset(4, 1, 4))) {
            if (!p_53259_.getFluidState(blockpos).is(FluidTags.WATER)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)p_53259_, (BlockPos)p_53260_);
    }

    private static boolean isUnderCrops(BlockGetter world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos.below());
        return blockState.getBlock() instanceof CropBlock;
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        int moistureLevel = (Integer)state.getValue((Property)MOISTURE);
        if (!CorruptSoilFarmLandBlock.isNearWater((LevelReader)worldIn, pos) && !worldIn.isRainingAt(pos.above())) {
            if (moistureLevel > 0) {
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(moistureLevel - 1)), 2);
            } else if (!CorruptSoilFarmLandBlock.isUnderCrops((BlockGetter)worldIn, pos)) {
                CorruptSoilFarmLandBlock.turnToDirt(state, (Level)worldIn, pos);
                return;
            }
        } else if (moistureLevel < 7) {
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
        BlockPos abovePos = pos.above();
        BlockState cropState = worldIn.getBlockState(abovePos);
        Block cropBlock = cropState.getBlock();
        if (cropBlock instanceof CropBlock && cropBlock != ModBlocks.CORRUPT_CROP.get()) {
            int randomNumber = rand.nextInt(100);
            if (randomNumber < 60) {
                worldIn.setBlock(pos.above(), Blocks.AIR.defaultBlockState(), 3);
            } else {
                worldIn.setBlock(pos.above(), ((Block)ModBlocks.CORRUPT_CROP.get()).defaultBlockState(), 3);
            }
        }
    }

    public static void turnToDirt(BlockState p_53297_, Level p_53298_, BlockPos p_53299_) {
        p_53298_.setBlockAndUpdate(p_53299_, CorruptSoilFarmLandBlock.pushEntitiesUp((BlockState)p_53297_, (BlockState)((Block)ModBlocks.CORRUPT_SOIL.get()).defaultBlockState(), (LevelAccessor)p_53298_, (BlockPos)p_53299_));
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType plantType = plantable.getPlantType(world, pos.relative(facing));
        return plantType == PlantType.CROP || plantType == PlantType.PLAINS;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return !this.defaultBlockState().canSurvive((LevelReader)context.getLevel(), context.getClickedPos()) ? ((Block)ModBlocks.CORRUPT_SOIL.get()).defaultBlockState() : super.getStateForPlacement(context);
    }

    public void fallOn(Level p_153227_, BlockState p_153228_, BlockPos p_153229_, Entity p_153230_, float p_153231_) {
        if (!p_153227_.isClientSide && ForgeHooks.onFarmlandTrample((Level)p_153227_, (BlockPos)p_153229_, (BlockState)((Block)ModBlocks.CORRUPT_SOIL.get()).defaultBlockState(), (float)p_153231_, (Entity)p_153230_)) {
            CorruptSoilFarmLandBlock.turnToDirt(p_153228_, p_153227_, p_153229_);
        }
        super.fallOn(p_153227_, p_153228_, p_153229_, p_153230_, p_153231_);
    }
}

