/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.block;

import com.fruitstack.fruitstack.common.registry.ModBlocks;
import com.fruitstack.fruitstack.common.registry.ModItems;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FruitWineBarrelBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)9);
    protected static final VoxelShape SHAPE = Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    public final Supplier<Item> wineItem;
    public final Supplier<Item> wineTwoItem;
    public final Supplier<Item> wineThreeItem;
    public final Supplier<Item> wineFourItem;
    public final Supplier<Item> wineFiveItem;
    public final Supplier<Item> wineSixItem;
    public final Supplier<Item> wineSevenItem;
    public final Supplier<Item> wineEightItem;
    public final Supplier<Item> wineNineItem;
    public final Supplier<Item> wineTenItem;
    public final Supplier<Item> wineBeatItem;

    public FruitWineBarrelBlock(BlockBehaviour.Properties properties, Supplier<Item> wineItem, Supplier<Item> wineTwoItem, Supplier<Item> wineThreeItem, Supplier<Item> wineFourItem, Supplier<Item> wineFiveItem, Supplier<Item> wineSixItem, Supplier<Item> wineSevenItem, Supplier<Item> wineEightItem, Supplier<Item> wineNineItem, Supplier<Item> wineTenItem, Supplier<Item> wineBeatItem) {
        super(properties);
        this.wineItem = wineItem;
        this.wineTwoItem = wineTwoItem;
        this.wineThreeItem = wineThreeItem;
        this.wineFourItem = wineFourItem;
        this.wineFiveItem = wineFiveItem;
        this.wineSixItem = wineSixItem;
        this.wineSevenItem = wineSevenItem;
        this.wineEightItem = wineEightItem;
        this.wineNineItem = wineNineItem;
        this.wineTenItem = wineTenItem;
        this.wineBeatItem = wineBeatItem;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public ItemStack getWineItem(BlockState state) {
        return new ItemStack((ItemLike)this.wineItem.get());
    }

    public ItemStack getWineTwoItem(BlockState state) {
        return new ItemStack((ItemLike)this.wineTwoItem.get());
    }

    public ItemStack getWineThreeItem(BlockState state) {
        return new ItemStack((ItemLike)this.wineThreeItem.get());
    }

    public ItemStack getWineFourItem(BlockState state) {
        return new ItemStack((ItemLike)this.wineFourItem.get());
    }

    public ItemStack getWineFiveItem(BlockState state) {
        return new ItemStack((ItemLike)this.wineFiveItem.get());
    }

    public ItemStack getWineSixItem(BlockState state) {
        return new ItemStack((ItemLike)this.wineSixItem.get());
    }

    public ItemStack getWineSevenItem(BlockState state) {
        return new ItemStack((ItemLike)this.wineSevenItem.get());
    }

    public ItemStack getWineEightItem(BlockState state) {
        return new ItemStack((ItemLike)this.wineEightItem.get());
    }

    public ItemStack getWineNineItem(BlockState state) {
        return new ItemStack((ItemLike)this.wineNineItem.get());
    }

    public ItemStack getWineTenItem(BlockState state) {
        return new ItemStack((ItemLike)this.wineTenItem.get());
    }

    public ItemStack getWineBeatItem(BlockState state) {
        return new ItemStack((ItemLike)this.wineBeatItem.get());
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.isClientSide && this.takeWine(level, pos, state, player, hand, hit).consumesAction()) {
            return InteractionResult.SUCCESS;
        }
        return this.takeWine(level, pos, state, player, hand, hit);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected InteractionResult takeWine(Level level, BlockPos pos, BlockState state, Player player, InteractionHand hand, BlockHitResult result) {
        int age = (Integer)state.getValue((Property)AGE);
        ItemStack heldStack = player.getItemInHand(hand);
        ItemStack wineItem0 = this.getWineItem(state);
        ItemStack wineItem1 = this.getWineTwoItem(state);
        ItemStack wineItem2 = this.getWineThreeItem(state);
        ItemStack wineItem3 = this.getWineFourItem(state);
        ItemStack wineItem4 = this.getWineFiveItem(state);
        ItemStack wineItem5 = this.getWineSixItem(state);
        ItemStack wineItem6 = this.getWineSevenItem(state);
        ItemStack wineItem7 = this.getWineEightItem(state);
        ItemStack wineItem8 = this.getWineNineItem(state);
        ItemStack wineItem9 = this.getWineTenItem(state);
        ItemStack wineItem10 = this.getWineBeatItem(state);
        if (heldStack.getItem() == ModItems.CANN.get()) {
            BlockPlaceContext blockPlaceContext = new BlockPlaceContext(new UseOnContext(level, player, hand, heldStack, result));
            BlockState originalState = level.getBlockState(pos);
            Direction originalDirection = (Direction)originalState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            BlockState newState = ((Block)ModBlocks.WINE_BARREL.get()).getStateForPlacement(blockPlaceContext);
            newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)originalDirection);
            level.setBlock(pos, newState, 3);
            heldStack.shrink(1);
            if (age == 0) {
                if (!player.getInventory().add(wineItem0)) {
                    player.drop(wineItem0, false);
                }
                level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (age == 1) {
                if (!player.getInventory().add(wineItem1)) {
                    player.drop(wineItem1, false);
                }
                level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (age == 2) {
                if (!player.getInventory().add(wineItem2)) {
                    player.drop(wineItem2, false);
                }
                level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (age == 3) {
                if (!player.getInventory().add(wineItem3)) {
                    player.drop(wineItem3, false);
                }
                level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (age == 4) {
                if (!player.getInventory().add(wineItem4)) {
                    player.drop(wineItem4, false);
                }
                level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (age == 5) {
                if (!player.getInventory().add(wineItem5)) {
                    player.drop(wineItem5, false);
                }
                level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (age == 6) {
                if (!player.getInventory().add(wineItem6)) {
                    player.drop(wineItem6, false);
                }
                level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (age == 7) {
                if (!player.getInventory().add(wineItem7)) {
                    player.drop(wineItem7, false);
                }
                level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (age == 8) {
                if (!player.getInventory().add(wineItem8)) {
                    player.drop(wineItem8, false);
                }
                level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (age == 9) {
                ItemStack wineItem;
                Random random = new Random();
                double probability = random.nextDouble();
                ItemStack itemStack = wineItem = probability < 0.001 ? wineItem10 : wineItem9;
                if (!player.getInventory().add(wineItem)) {
                    player.drop(wineItem, false);
                }
                level.playSound(null, pos, SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return !level.isEmptyBlock(pos.below());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, AGE});
        super.createBlockStateDefinition(builder);
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (!worldIn.isClientSide && rand.nextFloat() <= 0.1f) {
            int age = (Integer)state.getValue((Property)AGE);
            if (age == 0) {
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(1)), 3);
                worldIn.updateNeighborsAt(pos, (Block)this);
            } else if (age == 1) {
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(2)), 3);
                worldIn.updateNeighborsAt(pos, (Block)this);
            } else if (age == 2) {
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(3)), 3);
                worldIn.updateNeighborsAt(pos, (Block)this);
            } else if (age == 3) {
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(4)), 3);
                worldIn.updateNeighborsAt(pos, (Block)this);
            } else if (age == 4) {
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(5)), 3);
                worldIn.updateNeighborsAt(pos, (Block)this);
            } else if (age == 5) {
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(6)), 3);
                worldIn.updateNeighborsAt(pos, (Block)this);
            } else if (age == 6) {
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(7)), 3);
                worldIn.updateNeighborsAt(pos, (Block)this);
            } else if (age == 7) {
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(8)), 3);
                worldIn.updateNeighborsAt(pos, (Block)this);
            } else if (age == 8) {
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(9)), 3);
                worldIn.updateNeighborsAt(pos, (Block)this);
            }
        }
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return true;
    }

    public boolean isSignalSource(BlockState p_55213_) {
        return true;
    }

    public int getSignal(BlockState p_55208_, BlockGetter p_55209_, BlockPos p_55210_, Direction p_55211_) {
        int age = (Integer)p_55208_.getValue((Property)AGE);
        return age + 1;
    }
}

