/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.block;

import com.fruitstack.fruitstack.common.registry.ModBlocks;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GrapeBottomBlock
extends Block {
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)2);
    protected static final VoxelShape SHAPE = Block.box((double)5.0, (double)1.0, (double)5.0, (double)10.0, (double)15.0, (double)10.0);
    private final Supplier<Block> grapeMiddle;

    public GrapeBottomBlock(Supplier<Block> grapeMiddle, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
        this.grapeMiddle = grapeMiddle;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, facingState, level, pos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).is(Blocks.GRASS_BLOCK);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
        super.createBlockStateDefinition(builder);
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (!worldIn.isClientSide && rand.nextFloat() <= 0.1f) {
            int age = (Integer)state.getValue((Property)AGE);
            if (age == 0) {
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(1)), 3);
            } else if (age == 1) {
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(2)), 3);
            } else if (age == 2 && worldIn.getBlockState(pos.above()).isAir()) {
                worldIn.setBlock(pos.above(), this.grapeMiddle.get().defaultBlockState(), 3);
            }
        }
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.isClientSide && this.boneMeal((LevelAccessor)level, pos, state, player, hand).consumesAction()) {
            return InteractionResult.SUCCESS;
        }
        return this.boneMeal((LevelAccessor)level, pos, state, player, hand);
    }

    protected InteractionResult boneMeal(LevelAccessor level, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        int age = (Integer)state.getValue((Property)AGE);
        ItemStack heldStack = player.getItemInHand(hand);
        if (age == 0 && heldStack.getItem() == Items.BONE_MEAL) {
            level.playSound(null, pos, SoundEvents.BONE_MEAL_USE, SoundSource.PLAYERS, 0.8f, 0.8f);
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(1)), 3);
            heldStack.shrink(1);
            level.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0, 0.1, 0.0);
            return InteractionResult.SUCCESS;
        }
        if (age == 1 && heldStack.getItem() == Items.BONE_MEAL) {
            level.playSound(null, pos, SoundEvents.BONE_MEAL_USE, SoundSource.PLAYERS, 0.8f, 0.8f);
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(2)), 3);
            heldStack.shrink(1);
            level.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0, 0.1, 0.0);
            return InteractionResult.SUCCESS;
        }
        if (age == 2 && heldStack.getItem() == Items.BONE_MEAL) {
            level.playSound(null, pos, SoundEvents.BONE_MEAL_USE, SoundSource.PLAYERS, 0.8f, 0.8f);
            level.setBlock(pos.above(), ((Block)ModBlocks.GRAPE_CROP_MIDDLE.get()).defaultBlockState(), 3);
            heldStack.shrink(1);
            level.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0, 0.1, 0.0);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

