/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.block;

import com.fruitstack.fruitstack.common.block.BaseCropBlock;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class HighCrop
extends BaseCropBlock {
    public static final BooleanProperty UPPER = BooleanProperty.create((String)"upper");
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public HighCrop(BlockBehaviour.Properties proper, Supplier<? extends ItemLike> seed) {
        super(proper, seed);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)UPPER, (Comparable)Boolean.valueOf(false)));
    }

    public BooleanProperty getUpperProperty() {
        return UPPER;
    }

    public int getGrowUpperAge() {
        return 3;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, UPPER});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.getValue((Property)this.getAgeProperty())];
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos downpos = pos.below();
        if (worldIn.getBlockState(downpos).is((Block)this)) {
            return (Boolean)worldIn.getBlockState(downpos).getValue((Property)this.getUpperProperty()) == false && (worldIn.getRawBrightness(pos, 0) >= 8 || worldIn.canSeeSky(pos)) && this.getAge(worldIn.getBlockState(downpos)) >= this.getGrowUpperAge();
        }
        return super.canSurvive(state, worldIn, pos);
    }

    public BlockState getStateForAge(int age) {
        return super.getStateForAge(age);
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        float f = HighCrop.getGrowthSpeed((Block)this, (BlockGetter)worldIn, (BlockPos)pos);
        int age = this.getAge(state);
        if (worldIn.getRawBrightness(pos, 0) >= 9 && age < this.getMaxAge() && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (rand.nextInt((int)(25.0f / f) + 1) == 0 ? 1 : 0) != 0)) {
            worldIn.setBlock(pos, (BlockState)this.getStateForAge(age + 1).setValue((Property)this.getUpperProperty(), (Comparable)((Boolean)state.getValue((Property)this.getUpperProperty()))), 2);
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
        if (((Boolean)state.getValue((Property)this.getUpperProperty())).booleanValue()) {
            return;
        }
        if (age >= this.getGrowUpperAge() && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (rand.nextInt((int)(25.0f / f) + 1) == 0 ? 1 : 0) != 0) && this.defaultBlockState().canSurvive((LevelReader)worldIn, pos.above()) && worldIn.isEmptyBlock(pos.above())) {
            worldIn.setBlockAndUpdate(pos.above(), (BlockState)this.defaultBlockState().setValue((Property)this.getUpperProperty(), (Comparable)Boolean.valueOf(true)));
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public boolean isValidBonemealTarget(LevelReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        BlockState upperState = worldIn.getBlockState(pos.above());
        if (upperState.is((Block)this)) {
            return !this.isMaxAge(upperState);
        }
        if (((Boolean)state.getValue((Property)this.getUpperProperty())).booleanValue()) {
            return !this.isMaxAge(state);
        }
        return true;
    }

    public boolean isBonemealSuccess(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        int ageGrowth = Math.min(this.getAge(state) + this.getBonemealAgeIncrease((Level)worldIn), 15);
        if (ageGrowth <= this.getMaxAge()) {
            worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(ageGrowth)));
        } else {
            worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(this.getMaxAge())));
            if (((Boolean)state.getValue((Property)this.getUpperProperty())).booleanValue()) {
                return;
            }
            BlockState top = worldIn.getBlockState(pos.above());
            if (top.is((Block)this)) {
                BonemealableBlock growable = (BonemealableBlock)worldIn.getBlockState(pos.above()).getBlock();
                if (growable.isValidBonemealTarget((LevelReader)worldIn, pos.above(), top, false)) {
                    growable.performBonemeal(worldIn, worldIn.random, pos.above(), top);
                }
            } else {
                int remainingGrowth = ageGrowth - this.getMaxAge() - 1;
                if (this.defaultBlockState().canSurvive((LevelReader)worldIn, pos.above()) && worldIn.isEmptyBlock(pos.above())) {
                    worldIn.setBlock(pos.above(), (BlockState)((BlockState)this.defaultBlockState().setValue((Property)this.getUpperProperty(), (Comparable)Boolean.valueOf(true))).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(remainingGrowth)), 3);
                }
            }
        }
    }
}

