/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class UnformedLitchiRiverDough
extends Block {
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)1);
    protected static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)3.0, (double)12.0, (double)4.0, (double)13.0);
    private final Supplier<Block> riverDough;

    public UnformedLitchiRiverDough(Supplier<Block> riverDough, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
        this.riverDough = riverDough;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, facingState, level, pos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return !level.isEmptyBlock(pos.below());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
        super.createBlockStateDefinition(builder);
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (!worldIn.isClientSide && rand.nextFloat() <= 0.1f) {
            int age = (Integer)state.getValue((Property)AGE);
            if (age == 0) {
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(1)), 3);
            } else if (age == 1) {
                worldIn.setBlock(pos, this.riverDough.get().defaultBlockState(), 3);
            }
        }
    }
}

