/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.block.entity;

import com.fruitstack.fruitstack.common.block.entity.SyncedBlockEntity;
import com.fruitstack.fruitstack.common.registry.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemStackHandler;

public class BowlBlockEntity
extends SyncedBlockEntity {
    private static final VoxelShape GRILLING_AREA = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0);
    private static final int INVENTORY_SLOT_COUNT = 1;
    private final ItemStackHandler inventory = this.createHandler();

    public BowlBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.BOWL_BLOCK.get(), pos, state);
    }

    public boolean addItem(ItemStack itemStackIn, int slot, Player player, InteractionHand hand) {
        if (0 <= slot && slot < this.inventory.getSlots()) {
            ItemStack heldStack = player.getItemInHand(hand);
            ItemStack slotStack = this.inventory.getStackInSlot(slot);
            int stackSize = heldStack.getCount();
            if (slotStack.isEmpty()) {
                this.inventory.setStackInSlot(slot, itemStackIn.copy());
                heldStack.shrink(stackSize);
                this.inventoryChanged();
                return true;
            }
        }
        return false;
    }

    public void giveItemShift(Player player) {
        ItemStack slotStack = this.inventory.getStackInSlot(0);
        if (!slotStack.isEmpty()) {
            int stackSize = slotStack.getCount();
            this.inventory.setStackInSlot(0, ItemStack.EMPTY);
            ItemStack extractedStack = new ItemStack((ItemLike)slotStack.getItem(), stackSize);
            if (!player.getInventory().add(extractedStack)) {
                player.drop(extractedStack, false);
            }
            this.inventoryChanged();
        }
    }

    public void giveItem(Player player) {
        ItemStack slotStack = this.inventory.getStackInSlot(0);
        if (!slotStack.isEmpty()) {
            ItemStack extractedStack = new ItemStack((ItemLike)slotStack.getItem(), 1);
            if (!player.getInventory().add(extractedStack)) {
                player.drop(extractedStack, false);
            }
            slotStack.setCount(slotStack.getCount() - 1);
            if (slotStack.getCount() <= 0) {
                this.inventory.setStackInSlot(0, ItemStack.EMPTY);
            }
            this.inventoryChanged();
        }
    }

    public void finishUsingItem(Player player) {
        ItemStack slotStack = this.inventory.getStackInSlot(0);
        if (!slotStack.isEmpty() && slotStack.getItem().isEdible()) {
            ItemStack extractedStack = new ItemStack((ItemLike)slotStack.getItem(), 1);
            player.eat(this.level, extractedStack);
            slotStack.setCount(slotStack.getCount() - 1);
            if (slotStack.getCount() <= 0) {
                this.inventory.setStackInSlot(0, ItemStack.EMPTY);
            }
            this.inventoryChanged();
        }
    }

    public void load(CompoundTag compound) {
        super.load(compound);
        if (compound.contains("Inventory")) {
            this.inventory.deserializeNBT(compound.getCompound("Inventory"));
        } else {
            this.inventory.deserializeNBT(compound);
        }
    }

    private CompoundTag writeItems(CompoundTag compound) {
        super.saveAdditional(compound);
        compound.put("Inventory", (Tag)this.inventory.serializeNBT());
        return compound;
    }

    public int getNextEmptySlot() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack slotStack = this.inventory.getStackInSlot(i);
            if (!slotStack.isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public boolean isBowlBlockedAbove() {
        if (this.level != null) {
            BlockState above = this.level.getBlockState(this.worldPosition.above());
            return Shapes.joinIsNotEmpty((VoxelShape)GRILLING_AREA, (VoxelShape)above.getShape((BlockGetter)this.level, this.worldPosition.above()), (BooleanOp)BooleanOp.AND);
        }
        return false;
    }

    public Vec3 getBowlItemOffset(int index) {
        Vec3[] OFFSETS = new Vec3[]{new Vec3(0.0, 0.0, 0.0)};
        return OFFSETS[index];
    }

    @Override
    public CompoundTag getUpdateTag() {
        return this.writeItems(new CompoundTag());
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            public int getSlotLimit(int slot) {
                return 64;
            }
        };
    }
}

