/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.block.entity;

import com.fruitstack.fruitstack.common.block.ClayOvenBlock;
import com.fruitstack.fruitstack.common.block.entity.SyncedBlockEntity;
import com.fruitstack.fruitstack.common.mixin.accessor.RecipeManagerAccessor;
import com.fruitstack.fruitstack.common.registry.ModBlockEntityTypes;
import com.fruitstack.fruitstack.common.utility.ItemUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ClayOvenBlockEntity
extends SyncedBlockEntity {
    private static final VoxelShape GRILLING_AREA = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private static final int INVENTORY_SLOT_COUNT = 6;
    private final ItemStackHandler inventory = this.createHandler();
    private final int[] cookingTimes = new int[6];
    private final int[] cookingTimesTotal = new int[6];
    private ResourceLocation[] lastRecipeIDs = new ResourceLocation[6];

    public ClayOvenBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.CLAY_OVEN.get(), pos, state);
    }

    public void load(CompoundTag compound) {
        super.load(compound);
        if (compound.contains("Inventory")) {
            this.inventory.deserializeNBT(compound.getCompound("Inventory"));
        } else {
            this.inventory.deserializeNBT(compound);
        }
        if (compound.contains("CookingTimes", 11)) {
            int[] arrayCookingTimes = compound.getIntArray("CookingTimes");
            System.arraycopy(arrayCookingTimes, 0, this.cookingTimes, 0, Math.min(this.cookingTimesTotal.length, arrayCookingTimes.length));
        }
        if (compound.contains("CookingTotalTimes", 11)) {
            int[] arrayCookingTimesTotal = compound.getIntArray("CookingTotalTimes");
            System.arraycopy(arrayCookingTimesTotal, 0, this.cookingTimesTotal, 0, Math.min(this.cookingTimesTotal.length, arrayCookingTimesTotal.length));
        }
    }

    public void saveAdditional(CompoundTag compound) {
        this.writeItems(compound);
        compound.putIntArray("CookingTimes", this.cookingTimes);
        compound.putIntArray("CookingTotalTimes", this.cookingTimesTotal);
    }

    private CompoundTag writeItems(CompoundTag compound) {
        super.saveAdditional(compound);
        compound.put("Inventory", (Tag)this.inventory.serializeNBT());
        return compound;
    }

    public static void cookingTick(Level level, BlockPos pos, BlockState state, ClayOvenBlockEntity calyoven) {
        boolean isCalyOvenLit = (Boolean)state.getValue((Property)ClayOvenBlock.LIT);
        if (calyoven.isCalyOvenBlockedAbove()) {
            if (!ItemUtils.isInventoryEmpty((IItemHandler)calyoven.inventory)) {
                ItemUtils.dropItems(level, pos, (IItemHandler)calyoven.inventory);
                calyoven.inventoryChanged();
            }
        } else if (isCalyOvenLit) {
            calyoven.cookAndOutputItems();
        } else {
            for (int i = 0; i < calyoven.inventory.getSlots(); ++i) {
                if (calyoven.cookingTimes[i] <= 0) continue;
                calyoven.cookingTimes[i] = Mth.clamp((int)(calyoven.cookingTimes[i] - 2), (int)0, (int)calyoven.cookingTimesTotal[i]);
            }
        }
    }

    public static void animationTick(Level level, BlockPos pos, BlockState state, ClayOvenBlockEntity calyoven) {
        for (int i = 0; i < calyoven.inventory.getSlots(); ++i) {
            if (calyoven.inventory.getStackInSlot(i).isEmpty() || !(level.random.nextFloat() < 0.2f)) continue;
            Vec2 calyovenItemVector = calyoven.getCalyOvenItemOffset(i);
            Direction direction = (Direction)state.getValue((Property)ClayOvenBlock.FACING);
            int directionIndex = direction.get2DDataValue();
            Vec2 offset = directionIndex % 2 == 0 ? calyovenItemVector : new Vec2(calyovenItemVector.y, calyovenItemVector.x);
            double x = (double)pos.getX() + 0.5 - (double)((float)direction.getStepX() * offset.x) + (double)((float)direction.getClockWise().getStepX() * offset.x);
            double y = (double)pos.getY() + 1.0;
            double z = (double)pos.getZ() + 0.5 - (double)((float)direction.getStepZ() * offset.y) + (double)((float)direction.getClockWise().getStepZ() * offset.y);
            for (int k = 0; k < 3; ++k) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    private void cookAndOutputItems() {
        if (this.level == null) {
            return;
        }
        boolean didInventoryChange = false;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack resultStack;
            ItemStack calyovenStack = this.inventory.getStackInSlot(i);
            if (calyovenStack.isEmpty()) continue;
            int n = i;
            this.cookingTimes[n] = this.cookingTimes[n] + 1;
            if (this.cookingTimes[i] < this.cookingTimesTotal[i]) continue;
            SimpleContainer inventoryWrapper = new SimpleContainer(new ItemStack[]{calyovenStack});
            Optional<CampfireCookingRecipe> recipe = this.getMatchingRecipe((Container)inventoryWrapper, i);
            if (recipe.isPresent() && !(resultStack = recipe.get().getResultItem(this.level.registryAccess())).isEmpty()) {
                ItemUtils.spawnItemEntity(this.level, resultStack.copy(), (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.0, (double)this.worldPosition.getZ() + 0.5, this.level.random.nextGaussian() * (double)0.01f, 0.1f, this.level.random.nextGaussian() * (double)0.01f);
            }
            this.inventory.setStackInSlot(i, ItemStack.EMPTY);
            didInventoryChange = true;
        }
        if (didInventoryChange) {
            this.inventoryChanged();
        }
    }

    public int getNextEmptySlot() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack slotStack = this.inventory.getStackInSlot(i);
            if (!slotStack.isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public boolean addItem(ItemStack itemStackIn, CampfireCookingRecipe recipe, int slot) {
        ItemStack slotStack;
        if (0 <= slot && slot < this.inventory.getSlots() && (slotStack = this.inventory.getStackInSlot(slot)).isEmpty()) {
            this.cookingTimesTotal[slot] = recipe.getCookingTime();
            this.cookingTimes[slot] = 0;
            this.inventory.setStackInSlot(slot, itemStackIn.split(1));
            this.lastRecipeIDs[slot] = recipe.getId();
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public Optional<CampfireCookingRecipe> getMatchingRecipe(Container recipeWrapper, int slot) {
        Recipe recipe;
        if (this.level == null) {
            return Optional.empty();
        }
        if (this.lastRecipeIDs[slot] != null && (recipe = ((RecipeManagerAccessor)this.level.getRecipeManager()).getRecipeMap(RecipeType.CAMPFIRE_COOKING).get(this.lastRecipeIDs[slot])) instanceof CampfireCookingRecipe && recipe.matches(recipeWrapper, this.level)) {
            return Optional.of((CampfireCookingRecipe)recipe);
        }
        return this.level.getRecipeManager().getRecipeFor(RecipeType.CAMPFIRE_COOKING, recipeWrapper, this.level);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public boolean isCalyOvenBlockedAbove() {
        if (this.level != null) {
            BlockState above = this.level.getBlockState(this.worldPosition.above());
            return Shapes.joinIsNotEmpty((VoxelShape)GRILLING_AREA, (VoxelShape)above.getShape((BlockGetter)this.level, this.worldPosition.above()), (BooleanOp)BooleanOp.AND);
        }
        return false;
    }

    public Vec2 getCalyOvenItemOffset(int index) {
        float X_OFFSET = 0.3f;
        float Y_OFFSET = 0.2f;
        Vec2[] OFFSETS = new Vec2[]{new Vec2(0.3f, 0.2f), new Vec2(0.0f, 0.2f), new Vec2(-0.3f, 0.2f), new Vec2(0.3f, -0.2f), new Vec2(0.0f, -0.2f), new Vec2(-0.3f, -0.2f)};
        return OFFSETS[index];
    }

    private void addParticles() {
        if (this.level == null) {
            return;
        }
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).isEmpty() || !(this.level.random.nextFloat() < 0.2f)) continue;
            Vec2 calyovenItemVector = this.getCalyOvenItemOffset(i);
            Direction direction = (Direction)this.getBlockState().getValue((Property)ClayOvenBlock.FACING);
            int directionIndex = direction.get2DDataValue();
            Vec2 offset = directionIndex % 2 == 0 ? calyovenItemVector : new Vec2(calyovenItemVector.y, calyovenItemVector.x);
            double x = (double)this.worldPosition.getX() + 0.5 - (double)((float)direction.getStepX() * offset.x) + (double)((float)direction.getClockWise().getStepX() * offset.x);
            double y = (double)this.worldPosition.getY() + 1.0;
            double z = (double)this.worldPosition.getZ() + 0.5 - (double)((float)direction.getStepZ() * offset.y) + (double)((float)direction.getClockWise().getStepZ() * offset.y);
            for (int k = 0; k < 3; ++k) {
                this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    @Override
    public CompoundTag getUpdateTag() {
        return this.writeItems(new CompoundTag());
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(6){

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }
}

