/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.block.entity;

import com.fruitstack.fruitstack.common.block.JuicerBlock;
import com.fruitstack.fruitstack.common.block.entity.HeatableBlockEntityTwo;
import com.fruitstack.fruitstack.common.block.entity.SyncedBlockEntity;
import com.fruitstack.fruitstack.common.block.entity.container.JuicerBlockMenu;
import com.fruitstack.fruitstack.common.block.entity.inventory.JuicerItemHandler;
import com.fruitstack.fruitstack.common.block.state.JuicerStage;
import com.fruitstack.fruitstack.common.crafting.JuicerRecipe;
import com.fruitstack.fruitstack.common.mixin.accessor.RecipeManagerAccessor;
import com.fruitstack.fruitstack.common.registry.ModBlockEntityTypes;
import com.fruitstack.fruitstack.common.registry.ModBlocks;
import com.fruitstack.fruitstack.common.registry.ModItems;
import com.fruitstack.fruitstack.common.registry.ModRecipeTypes;
import com.fruitstack.fruitstack.common.utility.ItemUtils;
import com.fruitstack.fruitstack.common.utility.TextUtils;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class JuicerBlockEntity
extends SyncedBlockEntity
implements MenuProvider,
HeatableBlockEntityTwo,
Nameable,
RecipeHolder {
    public static final int MEAL_DISPLAY_SLOT = 3;
    public static final int CONTAINER_SLOT = 4;
    public static final int OUTPUT_SLOT = 5;
    public static final int INVENTORY_SIZE = 6;
    public static final EnumProperty<JuicerStage> STAGE = EnumProperty.create((String)"stage", JuicerStage.class);
    public static final Map<Item, Item> INGREDIENT_REMAINDER_OVERRIDES = Map.ofEntries(Map.entry(Items.POWDER_SNOW_BUCKET, Items.BUCKET), Map.entry(Items.AXOLOTL_BUCKET, Items.BUCKET), Map.entry(Items.COD_BUCKET, Items.BUCKET), Map.entry(Items.PUFFERFISH_BUCKET, Items.BUCKET), Map.entry(Items.SALMON_BUCKET, Items.BUCKET), Map.entry(Items.TROPICAL_FISH_BUCKET, Items.BUCKET), Map.entry(Items.SUSPICIOUS_STEW, Items.BOWL), Map.entry(Items.MUSHROOM_STEW, Items.BOWL), Map.entry(Items.RABBIT_STEW, Items.BOWL), Map.entry(Items.BEETROOT_SOUP, Items.BOWL), Map.entry(Items.POTION, Items.GLASS_BOTTLE), Map.entry(Items.SPLASH_POTION, Items.GLASS_BOTTLE), Map.entry(Items.LINGERING_POTION, Items.GLASS_BOTTLE), Map.entry(Items.EXPERIENCE_BOTTLE, Items.GLASS_BOTTLE));
    private final ItemStackHandler inventory = this.createHandler();
    private final LazyOptional<IItemHandler> inputHandler = LazyOptional.of(() -> new JuicerItemHandler((IItemHandler)this.inventory, Direction.UP));
    private final LazyOptional<IItemHandler> outputHandler = LazyOptional.of(() -> new JuicerItemHandler((IItemHandler)this.inventory, Direction.DOWN));
    private int cookTime;
    private int cookTimeTotal;
    private ItemStack mealContainerStack = ItemStack.EMPTY;
    private Component customName;
    protected final ContainerData tripodVesselForMakingPillsOfImmortalityData = this.createIntArray();
    private final Object2IntOpenHashMap<ResourceLocation> usedRecipeTracker = new Object2IntOpenHashMap();
    private ResourceLocation lastRecipeID;
    private boolean checkNewRecipe = true;

    public JuicerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.JUICER.get(), pos, state);
    }

    public static ItemStack getMealFromItem(ItemStack tripodVesselForMakingPillsOfImmortalityStack) {
        CompoundTag inventoryTag;
        if (!tripodVesselForMakingPillsOfImmortalityStack.is((Item)ModItems.JUICER.get())) {
            return ItemStack.EMPTY;
        }
        CompoundTag compound = tripodVesselForMakingPillsOfImmortalityStack.getTagElement("BlockEntityTag");
        if (compound != null && (inventoryTag = compound.getCompound("Inventory")).contains("Items", 4)) {
            ItemStackHandler handler = new ItemStackHandler();
            handler.deserializeNBT(inventoryTag);
            return handler.getStackInSlot(3);
        }
        return ItemStack.EMPTY;
    }

    public static void takeServingFromItem(ItemStack tripodVesselForMakingPillsOfImmortalityStack) {
        CompoundTag inventoryTag;
        if (!tripodVesselForMakingPillsOfImmortalityStack.is((Item)ModItems.JUICER.get())) {
            return;
        }
        CompoundTag compound = tripodVesselForMakingPillsOfImmortalityStack.getTagElement("BlockEntityTag");
        if (compound != null && (inventoryTag = compound.getCompound("Inventory")).contains("Items", 4)) {
            ItemStackHandler handler = new ItemStackHandler();
            handler.deserializeNBT(inventoryTag);
            ItemStack newMealStack = handler.getStackInSlot(3);
            newMealStack.shrink(1);
            compound.remove("Inventory");
            compound.put("Inventory", (Tag)handler.serializeNBT());
        }
    }

    public static ItemStack getContainerFromItem(ItemStack tripodVesselForMakingPillsOfImmortalityStack) {
        if (!tripodVesselForMakingPillsOfImmortalityStack.is((Item)ModItems.JUICER.get())) {
            return ItemStack.EMPTY;
        }
        CompoundTag compound = tripodVesselForMakingPillsOfImmortalityStack.getTagElement("BlockEntityTag");
        if (compound != null) {
            return ItemStack.of((CompoundTag)compound.getCompound("Container"));
        }
        return ItemStack.EMPTY;
    }

    public void load(CompoundTag compound) {
        super.load(compound);
        this.inventory.deserializeNBT(compound.getCompound("Inventory"));
        this.cookTime = compound.getInt("CookTime");
        this.cookTimeTotal = compound.getInt("CookTimeTotal");
        this.mealContainerStack = ItemStack.of((CompoundTag)compound.getCompound("Container"));
        if (compound.contains("CustomName", 3)) {
            this.customName = Component.Serializer.fromJson((String)compound.getString("CustomName"));
        }
        CompoundTag compoundRecipes = compound.getCompound("RecipesUsed");
        for (String key : compoundRecipes.getAllKeys()) {
            this.usedRecipeTracker.put((Object)new ResourceLocation(key), compoundRecipes.getInt(key));
        }
    }

    public void saveAdditional(CompoundTag compound) {
        super.saveAdditional(compound);
        compound.putInt("CookTime", this.cookTime);
        compound.putInt("CookTimeTotal", this.cookTimeTotal);
        compound.put("Container", (Tag)this.mealContainerStack.serializeNBT());
        if (this.customName != null) {
            compound.putString("CustomName", Component.Serializer.toJson((Component)this.customName));
        }
        compound.put("Inventory", (Tag)this.inventory.serializeNBT());
        CompoundTag compoundRecipes = new CompoundTag();
        this.usedRecipeTracker.forEach((recipeId, craftedAmount) -> compoundRecipes.putInt(recipeId.toString(), craftedAmount.intValue()));
        compound.put("RecipesUsed", (Tag)compoundRecipes);
    }

    private CompoundTag writeItems(CompoundTag compound) {
        super.saveAdditional(compound);
        compound.put("Container", (Tag)this.mealContainerStack.serializeNBT());
        compound.put("Inventory", (Tag)this.inventory.serializeNBT());
        return compound;
    }

    public CompoundTag writeMeal(CompoundTag compound) {
        if (this.getMeal().isEmpty()) {
            return compound;
        }
        ItemStackHandler drops = new ItemStackHandler(6);
        for (int i = 0; i < 6; ++i) {
            drops.setStackInSlot(i, i == 3 ? this.inventory.getStackInSlot(i) : ItemStack.EMPTY);
        }
        if (this.customName != null) {
            compound.putString("CustomName", Component.Serializer.toJson((Component)this.customName));
        }
        compound.put("Container", (Tag)this.mealContainerStack.serializeNBT());
        compound.put("Inventory", (Tag)drops.serializeNBT());
        return compound;
    }

    public static void cookingTick(Level level, BlockPos pos, BlockState state, JuicerBlockEntity tripodVesselForMakingPillsOfImmortality) {
        boolean isHeated = tripodVesselForMakingPillsOfImmortality.isHeated(level, pos);
        boolean didInventoryChange = false;
        BlockState originalState = level.getBlockState(pos);
        if (isHeated && tripodVesselForMakingPillsOfImmortality.hasInput()) {
            Optional<JuicerRecipe> recipe = tripodVesselForMakingPillsOfImmortality.getMatchingRecipe(new RecipeWrapper((IItemHandlerModifiable)tripodVesselForMakingPillsOfImmortality.inventory));
            if (recipe.isPresent() && tripodVesselForMakingPillsOfImmortality.canCook(recipe.get())) {
                didInventoryChange = tripodVesselForMakingPillsOfImmortality.processCooking(recipe.get(), tripodVesselForMakingPillsOfImmortality);
            } else {
                tripodVesselForMakingPillsOfImmortality.cookTime = 0;
            }
        } else if (tripodVesselForMakingPillsOfImmortality.cookTime > 0) {
            tripodVesselForMakingPillsOfImmortality.cookTime = Mth.clamp((int)(tripodVesselForMakingPillsOfImmortality.cookTime - 2), (int)0, (int)tripodVesselForMakingPillsOfImmortality.cookTimeTotal);
        }
        ItemStack mealStack = tripodVesselForMakingPillsOfImmortality.getMeal();
        if (!mealStack.isEmpty()) {
            if (!tripodVesselForMakingPillsOfImmortality.doesMealHaveContainer(mealStack)) {
                tripodVesselForMakingPillsOfImmortality.moveMealToOutput();
                didInventoryChange = true;
            } else if (!tripodVesselForMakingPillsOfImmortality.inventory.getStackInSlot(4).isEmpty()) {
                tripodVesselForMakingPillsOfImmortality.useStoredContainersOnMeal();
                didInventoryChange = true;
            }
        }
        if (didInventoryChange) {
            tripodVesselForMakingPillsOfImmortality.inventoryChanged();
        }
        if (level.getBlockState(pos).getBlock() == ModBlocks.JUICER.get()) {
            if (tripodVesselForMakingPillsOfImmortality.cookTime >= tripodVesselForMakingPillsOfImmortality.cookTimeTotal) {
                level.setBlockAndUpdate(pos, (BlockState)originalState.setValue(STAGE, (Comparable)((Object)JuicerStage.OVER)));
            }
            if (isHeated && tripodVesselForMakingPillsOfImmortality.cookTimeTotal > 0 && tripodVesselForMakingPillsOfImmortality.cookTime < tripodVesselForMakingPillsOfImmortality.cookTimeTotal) {
                level.setBlockAndUpdate(pos, (BlockState)originalState.setValue(STAGE, (Comparable)((Object)JuicerStage.STIR)));
            } else if (tripodVesselForMakingPillsOfImmortality.cookTimeTotal > 0 && tripodVesselForMakingPillsOfImmortality.cookTime == tripodVesselForMakingPillsOfImmortality.cookTimeTotal) {
                level.setBlockAndUpdate(pos, (BlockState)originalState.setValue(STAGE, (Comparable)((Object)JuicerStage.OVER)));
            } else if (mealStack.isEmpty()) {
                level.setBlockAndUpdate(pos, (BlockState)originalState.setValue(STAGE, (Comparable)((Object)JuicerStage.NONE)));
            }
        }
    }

    private Optional<JuicerRecipe> getMatchingRecipe(RecipeWrapper inventoryWrapper) {
        Object recipe;
        if (this.level == null) {
            return Optional.empty();
        }
        if (this.lastRecipeID != null && (recipe = ((RecipeManagerAccessor)this.level.getRecipeManager()).getRecipeMap((RecipeType)ModRecipeTypes.JUICER.get()).get(this.lastRecipeID)) instanceof JuicerRecipe) {
            if (recipe.matches((Container)inventoryWrapper, this.level)) {
                return Optional.of((JuicerRecipe)recipe);
            }
            if (ItemStack.isSameItem((ItemStack)recipe.getResultItem(this.level.registryAccess()), (ItemStack)this.getMeal())) {
                return Optional.empty();
            }
        }
        if (this.checkNewRecipe && ((Optional)(recipe = this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipeTypes.JUICER.get(), (Container)inventoryWrapper, this.level))).isPresent()) {
            this.lastRecipeID = ((JuicerRecipe)((Optional)recipe).get()).getId();
            return recipe;
        }
        this.checkNewRecipe = false;
        return Optional.empty();
    }

    public ItemStack getContainer() {
        ItemStack mealStack = this.getMeal();
        if (!mealStack.isEmpty() && !this.mealContainerStack.isEmpty()) {
            return this.mealContainerStack;
        }
        return mealStack.getCraftingRemainingItem();
    }

    private boolean hasInput() {
        for (int i = 0; i < 3; ++i) {
            if (this.inventory.getStackInSlot(i).isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected boolean canCook(JuicerRecipe recipe) {
        if (this.hasInput()) {
            ItemStack resultStack = recipe.getResultItem(this.level.registryAccess());
            if (resultStack.isEmpty()) {
                return false;
            }
            ItemStack storedMealStack = this.inventory.getStackInSlot(3);
            if (storedMealStack.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItem((ItemStack)storedMealStack, (ItemStack)resultStack)) {
                return false;
            }
            if (storedMealStack.getCount() + resultStack.getCount() <= this.inventory.getSlotLimit(3)) {
                return true;
            }
            return storedMealStack.getCount() + resultStack.getCount() <= resultStack.getMaxStackSize();
        }
        return false;
    }

    private boolean processCooking(JuicerRecipe recipe, JuicerBlockEntity tripodVesselForMakingPillsOfImmortality) {
        if (this.level == null) {
            return false;
        }
        ++this.cookTime;
        this.cookTimeTotal = recipe.getCookTime();
        if (this.cookTime < this.cookTimeTotal) {
            return false;
        }
        this.cookTime = 0;
        this.mealContainerStack = recipe.getOutputContainer();
        ItemStack resultStack = recipe.getResultItem(this.level.registryAccess());
        ItemStack storedMealStack = this.inventory.getStackInSlot(3);
        if (storedMealStack.isEmpty()) {
            this.inventory.setStackInSlot(3, resultStack.copy());
        } else if (ItemStack.isSameItem((ItemStack)storedMealStack, (ItemStack)resultStack)) {
            storedMealStack.grow(resultStack.getCount());
        }
        tripodVesselForMakingPillsOfImmortality.setRecipeUsed(recipe);
        for (int i = 0; i < 3; ++i) {
            ItemStack slotStack = this.inventory.getStackInSlot(i);
            if (slotStack.hasCraftingRemainingItem()) {
                this.ejectIngredientRemainder(slotStack.getCraftingRemainingItem());
            } else if (INGREDIENT_REMAINDER_OVERRIDES.containsKey(slotStack.getItem())) {
                this.ejectIngredientRemainder(INGREDIENT_REMAINDER_OVERRIDES.get(slotStack.getItem()).getDefaultInstance());
            }
            if (slotStack.isEmpty()) continue;
            slotStack.shrink(1);
        }
        return true;
    }

    protected void ejectIngredientRemainder(ItemStack remainderStack) {
        Direction direction = ((Direction)this.getBlockState().getValue((Property)JuicerBlock.FACING)).getCounterClockWise();
        double x = (double)this.worldPosition.getX() + 0.5 + (double)direction.getStepX() * 0.25;
        double y = (double)this.worldPosition.getY() + 0.7;
        double z = (double)this.worldPosition.getZ() + 0.5 + (double)direction.getStepZ() * 0.25;
        ItemUtils.spawnItemEntity(this.level, remainderStack, x, y, z, (float)direction.getStepX() * 0.08f, 0.25, (float)direction.getStepZ() * 0.08f);
    }

    public void setRecipeUsed(@Nullable Recipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation recipeID = recipe.getId();
            this.usedRecipeTracker.addTo((Object)recipeID, 1);
        }
    }

    @Nullable
    public Recipe<?> getRecipeUsed() {
        return null;
    }

    public void awardUsedRecipes(Player player, List<ItemStack> items) {
        List<Recipe<?>> usedRecipes = this.getUsedRecipesAndPopExperience(player.level(), player.position());
        player.awardRecipes(usedRecipes);
        this.usedRecipeTracker.clear();
    }

    public List<Recipe<?>> getUsedRecipesAndPopExperience(Level level, Vec3 pos) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.usedRecipeTracker.object2IntEntrySet()) {
            level.getRecipeManager().byKey((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                JuicerBlockEntity.splitAndSpawnExperience((ServerLevel)level, pos, entry.getIntValue(), ((JuicerRecipe)recipe).getExperience());
            });
        }
        return list;
    }

    private static void splitAndSpawnExperience(ServerLevel level, Vec3 pos, int craftedAmount, float experience) {
        int expTotal = Mth.floor((float)((float)craftedAmount * experience));
        float expFraction = Mth.frac((float)((float)craftedAmount * experience));
        if (expFraction != 0.0f && Math.random() < (double)expFraction) {
            ++expTotal;
        }
        ExperienceOrb.award((ServerLevel)level, (Vec3)pos, (int)expTotal);
    }

    public boolean isHeated() {
        if (this.level == null) {
            return false;
        }
        return this.isHeated(this.level, this.worldPosition);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public ItemStack getMeal() {
        return this.inventory.getStackInSlot(3);
    }

    public NonNullList<ItemStack> getDroppableInventory() {
        NonNullList drops = NonNullList.create();
        for (int i = 0; i < 6; ++i) {
            if (i == 3) continue;
            drops.add((Object)this.inventory.getStackInSlot(i));
        }
        return drops;
    }

    private void moveMealToOutput() {
        ItemStack mealStack = this.inventory.getStackInSlot(3);
        ItemStack outputStack = this.inventory.getStackInSlot(5);
        int mealCount = Math.min(mealStack.getCount(), mealStack.getMaxStackSize() - outputStack.getCount());
        if (outputStack.isEmpty()) {
            this.inventory.setStackInSlot(5, mealStack.split(mealCount));
        } else if (outputStack.getItem() == mealStack.getItem()) {
            mealStack.shrink(mealCount);
            outputStack.grow(mealCount);
        }
    }

    private void useStoredContainersOnMeal() {
        ItemStack mealStack = this.inventory.getStackInSlot(3);
        ItemStack containerInputStack = this.inventory.getStackInSlot(4);
        ItemStack outputStack = this.inventory.getStackInSlot(5);
        if (this.isContainerValid(containerInputStack) && outputStack.getCount() < outputStack.getMaxStackSize()) {
            int smallerStackCount = Math.min(mealStack.getCount(), containerInputStack.getCount());
            int mealCount = Math.min(smallerStackCount, mealStack.getMaxStackSize() - outputStack.getCount());
            if (outputStack.isEmpty()) {
                containerInputStack.shrink(mealCount);
                this.inventory.setStackInSlot(5, mealStack.split(mealCount));
            } else if (outputStack.getItem() == mealStack.getItem()) {
                mealStack.shrink(mealCount);
                containerInputStack.shrink(mealCount);
                outputStack.grow(mealCount);
            }
        }
    }

    public ItemStack useHeldItemOnMeal(ItemStack container) {
        if (this.isContainerValid(container) && !this.getMeal().isEmpty()) {
            container.shrink(1);
            return this.getMeal().split(1);
        }
        return ItemStack.EMPTY;
    }

    private boolean doesMealHaveContainer(ItemStack meal) {
        return !this.mealContainerStack.isEmpty() || meal.hasCraftingRemainingItem();
    }

    public boolean isContainerValid(ItemStack containerItem) {
        if (containerItem.isEmpty()) {
            return false;
        }
        if (!this.mealContainerStack.isEmpty()) {
            return ItemStack.isSameItem((ItemStack)this.mealContainerStack, (ItemStack)containerItem);
        }
        return ItemStack.isSameItem((ItemStack)this.getMeal(), (ItemStack)containerItem);
    }

    public Component getName() {
        return this.customName != null ? this.customName : TextUtils.getTranslation("container.juicer", new Object[0]);
    }

    public Component getDisplayName() {
        return this.getName();
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }

    public AbstractContainerMenu createMenu(int id, Inventory player, Player entity) {
        return new JuicerBlockMenu(id, player, this, this.tripodVesselForMakingPillsOfImmortalityData);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)ForgeCapabilities.ITEM_HANDLER)) {
            if (side == null || side.equals((Object)Direction.UP)) {
                return this.inputHandler.cast();
            }
            return this.outputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void setRemoved() {
        super.setRemoved();
        this.inputHandler.invalidate();
        this.outputHandler.invalidate();
    }

    @Override
    public CompoundTag getUpdateTag() {
        return this.writeItems(new CompoundTag());
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(6){

            protected void onContentsChanged(int slot) {
                if (slot >= 0 && slot < 3) {
                    JuicerBlockEntity.this.checkNewRecipe = true;
                }
                JuicerBlockEntity.this.inventoryChanged();
            }
        };
    }

    private ContainerData createIntArray() {
        return new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> JuicerBlockEntity.this.cookTime;
                    case 1 -> JuicerBlockEntity.this.cookTimeTotal;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        JuicerBlockEntity.this.cookTime = value;
                        break;
                    }
                    case 1: {
                        JuicerBlockEntity.this.cookTimeTotal = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public Vec3 getJuicerItemOffset(int index) {
        Vec3[] OFFSETS = new Vec3[]{new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0)};
        return OFFSETS[index];
    }
}

