/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.effect;

import java.util.UUID;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class CrispEffect
extends MobEffect {
    private final AttributeModifier damageModifier = new AttributeModifier(UUID.randomUUID(), "additional_damage", 10.0, AttributeModifier.Operation.ADDITION);
    private final AttributeModifier speedModifier = new AttributeModifier(UUID.randomUUID(), "custom_speed", 10.0, AttributeModifier.Operation.MULTIPLY_TOTAL);

    public CrispEffect() {
        super(MobEffectCategory.BENEFICIAL, 0);
    }

    public void applyEffectTick(LivingEntity entity, int amplifier) {
        Player player;
        if (!entity.getCommandSenderWorld().isClientSide && entity instanceof Player && (player = (Player)entity).getHealth() > 10.0f) {
            AttributeInstance speedAttribute;
            entity.hurt(entity.damageSources().magic(), 2.0f);
            AttributeInstance damageAttribute = player.getAttribute(Attributes.ATTACK_DAMAGE);
            if (!damageAttribute.hasModifier(this.damageModifier)) {
                damageAttribute.addTransientModifier(this.damageModifier);
            }
            if (!(speedAttribute = player.getAttribute(Attributes.MOVEMENT_SPEED)).hasModifier(this.speedModifier)) {
                speedAttribute.addTransientModifier(this.speedModifier);
            }
        }
    }

    public void removeAttributeModifiers(LivingEntity entity, AttributeMap attributes, int amplifier) {
        AttributeInstance speedAttribute;
        super.removeAttributeModifiers(entity, attributes, amplifier);
        AttributeInstance damageAttribute = entity.getAttribute(Attributes.ATTACK_DAMAGE);
        if (damageAttribute != null) {
            damageAttribute.removeModifier(this.damageModifier);
        }
        if ((speedAttribute = entity.getAttribute(Attributes.MOVEMENT_SPEED)) != null) {
            speedAttribute.removeModifier(this.speedModifier);
        }
    }

    public boolean isDurationEffectTick(int duration, int amplifier) {
        return true;
    }
}

