/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.effect;

import java.util.UUID;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class SweetEffect
extends MobEffect {
    private final AttributeModifier armorModifier = new AttributeModifier(UUID.randomUUID(), "custom_armor", 20.0, AttributeModifier.Operation.ADDITION);
    private final AttributeModifier speedModifier = new AttributeModifier(UUID.randomUUID(), "custom_speed", -0.8, AttributeModifier.Operation.MULTIPLY_TOTAL);

    public SweetEffect() {
        super(MobEffectCategory.BENEFICIAL, 16753920);
    }

    public void applyEffectTick(LivingEntity entity, int amplifier) {
        AttributeInstance speedAttribute;
        Player player;
        AttributeInstance armorAttribute;
        if (entity instanceof Player && !(armorAttribute = (player = (Player)entity).getAttribute(Attributes.ARMOR)).hasModifier(this.armorModifier)) {
            armorAttribute.addTransientModifier(this.armorModifier);
        }
        if (entity instanceof Player && !(speedAttribute = (player = (Player)entity).getAttribute(Attributes.MOVEMENT_SPEED)).hasModifier(this.speedModifier)) {
            speedAttribute.addTransientModifier(this.speedModifier);
        }
    }

    public void removeAttributeModifiers(LivingEntity entity, AttributeMap attributes, int amplifier) {
        AttributeInstance speedAttribute;
        super.removeAttributeModifiers(entity, attributes, amplifier);
        AttributeInstance armorAttribute = entity.getAttribute(Attributes.ARMOR);
        if (armorAttribute != null) {
            armorAttribute.removeModifier(this.armorModifier);
        }
        if ((speedAttribute = entity.getAttribute(Attributes.MOVEMENT_SPEED)) != null) {
            speedAttribute.removeModifier(this.speedModifier);
        }
    }

    public boolean isDurationEffectTick(int duration, int amplifier) {
        return true;
    }
}

