/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.common.world.modifier;

import com.fruitstack.fruitstack.common.registry.ModBiomeModifiers;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public record AddFeaturesByFilterBiomeModifier(HolderSet<Biome> allowedBiomes, Optional<HolderSet<Biome>> deniedBiomes, Optional<Float> minimumTemperature, Optional<Float> maximumTemperature, HolderSet<PlacedFeature> features, GenerationStep.Decoration step) implements BiomeModifier
{
    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD && this.allowedBiomes.contains(biome)) {
            if (this.deniedBiomes.isPresent() && this.deniedBiomes.get().contains(biome)) {
                return;
            }
            if (this.minimumTemperature.isPresent() && ((Biome)biome.get()).getBaseTemperature() < this.minimumTemperature.get().floatValue()) {
                return;
            }
            if (this.maximumTemperature.isPresent() && ((Biome)biome.get()).getBaseTemperature() > this.maximumTemperature.get().floatValue()) {
                return;
            }
            BiomeGenerationSettingsBuilder generationSettings = builder.getGenerationSettings();
            this.features.forEach(holder -> generationSettings.addFeature(this.step, holder));
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)ModBiomeModifiers.ADD_FEATURES_BY_FILTER.get();
    }
}

