/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.data;

import com.fruitstack.fruitstack.common.block.ClayOvenBlock;
import com.fruitstack.fruitstack.common.block.FeastBlock;
import com.fruitstack.fruitstack.common.block.PieBlock;
import com.fruitstack.fruitstack.common.registry.ModBlocks;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockStates
extends BlockStateProvider {
    private static final int DEFAULT_ANGLE_OFFSET = 180;

    public BlockStates(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "fruitstack", exFileHelper);
    }

    private String blockName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).getPath();
    }

    public ResourceLocation resourceBlock(String path) {
        return new ResourceLocation("fruitstack", "block/" + path);
    }

    public ModelFile existingModel(Block block) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(this.blockName(block)), this.models().existingFileHelper);
    }

    public ModelFile existingModel(String path) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(path), this.models().existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.horizontalBlock((Block)ModBlocks.CLAY_OVEN.get(), state -> {
            String name = this.blockName((Block)ModBlocks.CLAY_OVEN.get());
            String suffix = (Boolean)state.getValue((Property)ClayOvenBlock.LIT) != false ? "_on" : "";
            return this.models().orientableWithBottom(name + suffix, this.resourceBlock(name + "_side"), this.resourceBlock(name + "_front" + suffix), this.resourceBlock(name + "_bottom"), this.resourceBlock(name + "_top" + suffix));
        });
    }

    public ConfiguredModel[] cubeRandomRotation(Block block, String suffix) {
        String formattedName = this.blockName(block) + (String)(suffix.isEmpty() ? "" : "_" + suffix);
        return ConfiguredModel.allYRotations((ModelFile)this.models().cubeAll(formattedName, this.resourceBlock(formattedName)), (int)0, (boolean)false);
    }

    public void customDirectionalBlock(Block block, Function<BlockState, ModelFile> modelFunc, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            Direction dir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(dir == Direction.DOWN ? 180 : (dir.getAxis().isHorizontal() ? 90 : 0)).rotationY(dir.getAxis().isVertical() ? 0 : ((int)dir.toYRot() + 180) % 360).build();
        }, ignored);
    }

    public void customHorizontalBlock(Block block, Function<BlockState, ModelFile> modelFunc, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationY(((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 180) % 360).build(), ignored);
    }

    public void stageBlock(Block block, IntegerProperty ageProperty, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int ageSuffix = (Integer)state.getValue((Property)ageProperty);
            String stageName = this.blockName(block) + "_stage" + ageSuffix;
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().cross(stageName, this.resourceBlock(stageName))).build();
        }, ignored);
    }

    public void customStageBlock(Block block, @Nullable ResourceLocation parent, String textureKey, IntegerProperty ageProperty, List<Integer> suffixes, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int ageSuffix = (Integer)state.getValue((Property)ageProperty);
            String stageName = this.blockName(block) + "_stage";
            stageName = stageName + (suffixes.isEmpty() ? ageSuffix : (Integer)suffixes.get(Math.min(suffixes.size(), ageSuffix)));
            if (parent == null) {
                return ConfiguredModel.builder().modelFile((ModelFile)this.models().cross(stageName, this.resourceBlock(stageName))).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().singleTexture(stageName, parent, textureKey, this.resourceBlock(stageName))).build();
        }, ignored);
    }

    public void wildCropBlock(Block block) {
        this.wildCropBlock(block, false);
    }

    public void wildCropBlock(Block block, boolean isBushCrop) {
        if (isBushCrop) {
            this.simpleBlock(block, (ModelFile)this.models().singleTexture(this.blockName(block), this.resourceBlock("bush_crop"), "crop", this.resourceBlock(this.blockName(block))));
        } else {
            this.simpleBlock(block, (ModelFile)this.models().cross(this.blockName(block), this.resourceBlock(this.blockName(block))));
        }
    }

    public void crateBlock(Block block, String cropName) {
        this.simpleBlock(block, (ModelFile)this.models().cubeBottomTop(this.blockName(block), this.resourceBlock(cropName + "_crate_side"), this.resourceBlock("crate_bottom"), this.resourceBlock(cropName + "_crate_top")));
    }

    public void feastBlock(FeastBlock block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            IntegerProperty servingsProperty = block.getServingsProperty();
            int servings = (Integer)state.getValue((Property)servingsProperty);
            Object suffix = "_stage" + (block.getMaxServings() - servings);
            if (servings == 0) {
                suffix = block.hasLeftovers ? "_leftover" : "_stage" + (servingsProperty.getPossibleValues().toArray().length - 2);
            }
            return ConfiguredModel.builder().modelFile(this.existingModel(this.blockName(block) + (String)suffix)).rotationY(((int)((Direction)state.getValue((Property)FeastBlock.FACING)).toYRot() + 180) % 360).build();
        });
    }

    public void doublePlantBlock(Block block) {
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER).modelForState().modelFile((ModelFile)this.models().cross(this.blockName(block) + "_bottom", this.resourceBlock(this.blockName(block) + "_bottom"))).addModel()).partialState().with((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER).modelForState().modelFile((ModelFile)this.models().cross(this.blockName(block) + "_top", this.resourceBlock(this.blockName(block) + "_top"))).addModel();
    }

    public void pieBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int bites = (Integer)state.getValue((Property)PieBlock.BITES);
            Object suffix = bites > 0 ? "_slice" + bites : "";
            return ConfiguredModel.builder().modelFile(this.existingModel(this.blockName(block) + (String)suffix)).rotationY(((int)((Direction)state.getValue((Property)PieBlock.FACING)).toYRot() + 180) % 360).build();
        });
    }
}

