/*
 * Decompiled with CFR 0.152.
 */
package com.fruitstack.fruitstack.data;

import com.fruitstack.fruitstack.fruitstack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemModels
extends ItemModelProvider {
    public static final String GENERATED = "item/generated";
    public static final String HANDHELD = "item/handheld";
    public static final ResourceLocation MUG = new ResourceLocation("fruitstack", "item/mug");

    public ItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "fruitstack", existingFileHelper);
    }

    protected void registerModels() {
        Set items = ForgeRegistries.ITEMS.getValues().stream().filter(i -> "fruitstack".equals(ForgeRegistries.ITEMS.getKey(i).getNamespace())).collect(Collectors.toSet());
    }

    public void blockBasedModel(Item item, String suffix) {
        this.withExistingParent(this.itemName(item), this.resourceBlock(this.itemName(item) + suffix));
    }

    public void itemHandheldModel(Item item, ResourceLocation texture) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), HANDHELD)).texture("layer0", texture);
    }

    public void itemGeneratedModel(Item item, ResourceLocation texture) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), GENERATED)).texture("layer0", texture);
    }

    public void itemMugModel(Item item, ResourceLocation texture) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), MUG)).texture("layer0", texture);
    }

    private String itemName(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item).getPath();
    }

    public ResourceLocation resourceBlock(String path) {
        return new ResourceLocation("fruitstack", "block/" + path);
    }

    public ResourceLocation resourceItem(String path) {
        return new ResourceLocation("fruitstack", "item/" + path);
    }

    @SafeVarargs
    public static <T> Collection<T> takeAll(Set<? extends T> src, T ... items) {
        List<T> ret = Arrays.asList(items);
        for (T item : items) {
            if (src.contains(item)) continue;
            fruitstack.LOGGER.warn("Item {} not found in set", item);
        }
        if (!src.removeAll(ret)) {
            fruitstack.LOGGER.warn("takeAll array didn't yield anything ({})", (Object)Arrays.toString(items));
        }
        return ret;
    }

    public static <T> Collection<T> takeAll(Set<T> src, Predicate<T> pred) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterator<T> iter = src.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            if (!pred.test(item)) continue;
            iter.remove();
            ret.add(item);
        }
        if (ret.isEmpty()) {
            fruitstack.LOGGER.warn("takeAll predicate yielded nothing", new Throwable());
        }
        return ret;
    }
}

