/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.compat.msm.common.autocraftguide.base;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import com.github.wallev.maidsoulkitchen.compat.msm.common.craft.base.EnchantCommonPickupItemAction;
import com.github.wallev.maidsoulkitchen.compat.msm.common.util.CraftActionTypes;
import com.github.wallev.maidsoulkitchen.compat.msm.common.util.CraftGuideOperator2;
import com.github.wallev.maidsoulkitchen.compat.msm.common.util.action.TargetUtil;
import com.github.wallev.maidsoulkitchen.vhelper.client.chat.VComponent;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOption;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOptionSet;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.cache.RecipeIngredientCache;
import studio.fantasyit.maid_storage_manager.craft.generator.type.base.IAutoCraftGuideGenerator;
import studio.fantasyit.maid_storage_manager.craft.generator.util.GenerateCondition;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.storage.ItemHandler.ItemHandlerStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.PosUtil;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;

public interface ICookingGuideGenerator<R>
extends IAutoCraftGuideGenerator {
    public static final CraftActionTypes CRAFT_ACTION_TYPE = CraftActionTypes.INSTANCE;
    public static final Item DEFAULT_ITEM = ItemStack.f_41583_.m_41720_();

    default public boolean isValidWaterBlock(Level level, BlockPos pos) {
        if (!level.m_8055_(pos).m_60713_(Blocks.f_49990_)) {
            return false;
        }
        MutableInt count = new MutableInt(0);
        PosUtil.findAround((BlockPos)pos, t -> {
            if (level.m_8055_(t).m_60713_(Blocks.f_49990_)) {
                count.increment();
            }
            return null;
        });
        return count.intValue() >= 3;
    }

    default public boolean isSameMaidPos(EntityMaid maid, BlockPos pos) {
        return maid.f_19826_.equals((Object)pos);
    }

    default public boolean isValidGroundBlock(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60838_((BlockGetter)level, pos) && StorageAccessUtil.getMarksForPosSet((Level)level, (Target)Target.virtual((BlockPos)pos, null), List.of(pos.m_122029_(), pos.m_122024_(), pos.m_122012_(), pos.m_122019_())).stream().map(Pair::getB).anyMatch(t -> t.m_150930_((Item)ItemRegistry.ALLOW_ACCESS.get())) && PosUtil.findInUpperSquare((BlockPos)pos.m_7494_(), (int)1, (int)3, (int)1, t -> level.m_8055_(t).m_60795_() ? null : Boolean.valueOf(true)) == null;
    }

    public boolean isValidBlockInWorld(ServerLevel var1, EntityMaid var2, BlockPos var3, MaidPathFindingBFS var4);

    default public boolean positionalAvailable(ServerLevel level, EntityMaid maid, BlockPos pos, MaidPathFindingBFS pathFinding) {
        return this.isValidBlockInWorld(level, maid, pos, pathFinding) && super.positionalAvailable(level, maid, pos, pathFinding);
    }

    @NotNull
    public ResourceLocation getType();

    default public String toTypeStr() {
        String craftGuideLang = this.getType().toString().replace(":", ".").replace("/", "");
        return craftGuideLang;
    }

    default public void generate(List<InventoryItem> inventory, Level level, BlockPos pos, ICachableGeneratorGraph graph, Map<ResourceLocation, List<BlockPos>> recognizedTypePositions) {
        StorageAccessUtil.Filter posFilter = GenerateCondition.getFilterOn((Level)level, (BlockPos)pos);
        RegistryAccess registryAccess = level.m_9598_();
        this.consumeRecipes(level.m_7465_(), recipe -> {
            if (!this.isValidRecipe(recipe)) {
                return;
            }
            List<ItemStack> outputs = this.getOutputs(recipe, registryAccess);
            if (!posFilter.isAvailable(outputs.get(0))) {
                return;
            }
            this.generateCraftGuide(level, pos, graph, recipe, outputs);
        });
    }

    default public void generateCraftGuide(Level level, BlockPos pos, ICachableGeneratorGraph graph, R recipe, List<ItemStack> outputs) {
        boolean needContainer;
        ArrayList inputs = Lists.newArrayList(this.getInputs(recipe));
        List<Ingredient> containers = this.getContainers(recipe);
        boolean bl = needContainer = !containers.isEmpty();
        if (needContainer) {
            inputs.addAll(containers);
        }
        List<Integer> inputCounts = this.getInputCounts(inputs);
        ResourceLocation recipeId = this.getRecipeId(recipe);
        List<Ingredient> allInputs = this.getAllInputs(recipe);
        Function<List, CraftGuideData> craftGuideSupplier = items -> {
            CraftGuideOperator2 craftGuide = CraftGuideOperator2.create(pos);
            this.generateCraftGuideSteps(level, pos, recipe, outputs, (List<ItemStack>)items, needContainer, craftGuide);
            CraftGuideData craftGuideData = craftGuide.makeCraftGuideData();
            return craftGuideData;
        };
        graph.addRecipe(recipeId, allInputs, inputCounts, outputs, craftGuideSupplier);
    }

    default public void generateCraftGuideSteps(Level level, BlockPos pos, R recipe, List<ItemStack> outputs, List<ItemStack> items, boolean needContainer, CraftGuideOperator2 craftGuide) {
        ArrayList<ItemStack> realItems = new ArrayList<ItemStack>(items);
        List<ItemStack> remains = this.getRemains(recipe, realItems).stream().filter(itemStack -> !itemStack.m_41619_()).toList();
        ArrayList<ItemStack> oContainers = new ArrayList<ItemStack>();
        if (needContainer) {
            ItemStack remove = (ItemStack)realItems.remove(items.size() - 1);
            oContainers.add(remove);
        }
        this.generateSteps(pos, level, recipe, craftGuide, realItems, needContainer, oContainers, outputs, remains);
    }

    default public void generateSteps(BlockPos pos, Level level, R recipe, CraftGuideOperator2 craftGuide, List<ItemStack> realItems, boolean needContainer, List<ItemStack> containers, List<ItemStack> outputs, List<ItemStack> remains) {
        this.inputsStep(pos, craftGuide, realItems);
        this.outputContainerStep(pos, needContainer, craftGuide, containers);
        this.waitToOutputStep(pos, craftGuide, realItems, recipe);
        this.outputsStep(pos, craftGuide, outputs);
        this.remainStep(pos, craftGuide, remains);
    }

    default public void inputsStep(BlockPos pos, CraftGuideOperator2 craftGuide, List<ItemStack> realItems) {
        CraftGuideOperator2.forEach3Items(realItems, is -> craftGuide.addItemInsert(this.getInputStorageType(), Direction.UP, (List<ItemStack>)is));
    }

    default public ResourceLocation getInputStorageType() {
        return ItemHandlerStorage.TYPE;
    }

    default public void outputContainerStep(BlockPos pos, boolean needContainer, CraftGuideOperator2 craftGuide, List<ItemStack> containers) {
        if (needContainer) {
            CraftGuideOperator2.forEach3Items(containers, is -> craftGuide.addItemInsert(this.getOutputContainerStorageType(), Direction.EAST, (List<ItemStack>)is));
        }
    }

    default public ResourceLocation getOutputContainerStorageType() {
        return ItemHandlerStorage.TYPE;
    }

    default public void waitToOutputStep(BlockPos pos, CraftGuideOperator2 craftGuide, List<ItemStack> realItems, R recipe) {
        craftGuide.addIdle(this.getRecipeTime(recipe) + this.fixTime());
    }

    default public int fixTime() {
        return 5;
    }

    default public void outputsStep(BlockPos pos, CraftGuideOperator2 craftGuide, List<ItemStack> outputs) {
        CraftGuideOperator2.forEach3Items(outputs, is -> craftGuide.addItemTake(this.getOutputStorageType(), Direction.DOWN, (List<ItemStack>)is));
    }

    default public ResourceLocation getOutputStorageType() {
        return ItemHandlerStorage.TYPE;
    }

    default public void remainStep(BlockPos pos, CraftGuideOperator2 craftGuide, List<ItemStack> remains) {
    }

    default public void remainPickupStep(BlockPos pos, CraftGuideOperator2 craftGuide, List<ItemStack> remains) {
        CraftGuideOperator2.forEach3Items(remains, is -> craftGuide.addStep(new CraftGuideStepData(TargetUtil.makeTargetVirtualNoSide(pos), List.of(), is, EnchantCommonPickupItemAction.TYPE, ActionOptionSet.with((ActionOption)ActionOption.OPTIONAL, (Object)true))));
    }

    default public void remainTakeStep(BlockPos pos, CraftGuideOperator2 craftGuide, List<ItemStack> remains) {
        CraftGuideOperator2.forEach3Items(remains, craftGuide::addItemTake);
    }

    default public ResourceLocation getRemainStorageType() {
        return ItemHandlerStorage.TYPE;
    }

    default public int getRecipeTime(R recipe) {
        return 0;
    }

    default public List<ItemStack> getRemains(R recipe, List<ItemStack> inputs) {
        return List.of();
    }

    default public List<Integer> getInputCounts(List<Ingredient> inputs) {
        List<Integer> inputCounts = inputs.stream().map(t -> Arrays.stream(t.m_43908_()).findFirst().map(ItemStack::m_41613_).orElse(1)).toList();
        return inputCounts;
    }

    default public void onCache(RecipeManager manager) {
        this.consumeRecipes(manager, recipe -> {
            if (!this.shouldCacheRecipe(recipe)) {
                return;
            }
            if (!this.isValidRecipe(recipe)) {
                return;
            }
            ResourceLocation recipeId = this.getRecipeId(recipe);
            List<Ingredient> allInputs = this.getAllInputs(recipe);
            RecipeIngredientCache.addRecipeCache((ResourceLocation)recipeId, allInputs);
        });
    }

    public void consumeRecipes(RecipeManager var1, Consumer<R> var2);

    default public boolean isValidRecipe(List<InventoryItem> inventory, Level level, BlockPos pos, R recipe) {
        return this.isValidRecipe(recipe);
    }

    default public boolean isValidRecipe(R recipe) {
        return true;
    }

    default public boolean shouldCacheRecipe(R recipe) {
        return true;
    }

    public ResourceLocation getRecipeId(R var1);

    default public List<Ingredient> getAllInputs(R recipe) {
        List<Ingredient> inputs = this.getInputs(recipe);
        List<Ingredient> containers = this.getContainers(recipe);
        if (!containers.isEmpty()) {
            ArrayList<Ingredient> allInputs = new ArrayList<Ingredient>(inputs);
            allInputs.addAll(containers);
            return allInputs;
        }
        return inputs;
    }

    public List<Ingredient> getInputs(R var1);

    default public List<Ingredient> getContainers(R recipe) {
        return List.of();
    }

    public List<ItemStack> getOutputs(R var1, RegistryAccess var2);

    default public Component getConfigName() {
        String finalKey = "";
        String translateKey = this.getTranslateKey();
        if (I18n.m_118936_((String)translateKey)) {
            finalKey = translateKey;
        }
        String recipeIdFromJei = this.getRecipeTranslateKeyFromJei();
        if (finalKey.isEmpty() && !recipeIdFromJei.isEmpty()) {
            finalKey = recipeIdFromJei;
        }
        String descriptionId = this.getBlockItemForTranslate().m_5524_();
        if (finalKey.isEmpty() && !descriptionId.isEmpty()) {
            finalKey = descriptionId;
        }
        return VComponent.translatable(finalKey);
    }

    default public String getRecipeTranslateKeyFromJei() {
        String case0 = String.format("gui.jei.category.%s", this.getType().toString().replaceAll(":", "."));
        if (I18n.m_118936_((String)case0)) {
            return case0;
        }
        String case01 = String.format("gui.jei.category.%s.title", this.getType().toString().replaceAll(":", "."));
        if (I18n.m_118936_((String)case01)) {
            return case01;
        }
        String case02 = String.format("%s.recipe.%s", this.getType().m_135827_(), this.getType().m_135815_());
        if (I18n.m_118936_((String)case02)) {
            return case02;
        }
        String case1 = String.format("%s.jei.%s", this.getType().m_135827_(), this.getType().m_135815_());
        if (I18n.m_118936_((String)case1)) {
            return case1;
        }
        String case2 = String.format("%s.jei.title.%s", this.getType().m_135827_(), this.getType().m_135815_());
        if (I18n.m_118936_((String)case2)) {
            return case2;
        }
        String case3 = String.format("jei.%s.title", this.getType().toString().replaceAll(":", "."));
        if (I18n.m_118936_((String)case3)) {
            return case3;
        }
        return "";
    }

    default public String getTranslateKey() {
        String craftGuideLang = this.getType().toString().replace(":", ".").replace("/", "");
        return "config.maid_storage_manager.crafting.generating." + craftGuideLang;
    }

    default public List<Ingredient> toIngredients(ItemStack ... itemStack) {
        return Arrays.stream(itemStack).filter(itemStack1 -> !itemStack1.m_41619_()).map(xva$0 -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{xva$0})).toList();
    }

    default public List<ItemStack> toSpilt(List<ItemStack> items) {
        ArrayList<ItemStack> spiltItems = new ArrayList<ItemStack>();
        for (ItemStack item : items) {
            for (int i = 0; i < item.m_41613_(); ++i) {
                spiltItems.add(item.m_255036_(1));
            }
        }
        return spiltItems;
    }

    public Item getBlockItemForTranslate();
}

