/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.action;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOption;
import studio.fantasyit.maid_storage_manager.craft.context.AbstractCraftActionContext;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;

public record CraftAction(ResourceLocation type, CraftActionProvider provider, CraftActionPathFindingTargetProvider pathFindingTargetProvider, double pathCloseEnoughThreshold, boolean canBeCommon, long marks, int inputCount, int outputCount, List<ActionOption<?>> options) {
    public static final long MARK_NO_MARKS = 0L;
    public static final long MARK_NO_OCCUPATION = 1L;
    public static final long MARK_HAND_RELATED = 2L;

    public boolean hasOption(ActionOption<?> optional) {
        return this.options.stream().anyMatch(o -> o.id().equals((Object)optional.id()));
    }

    public boolean noOccupation() {
        return this.hasMark(1L);
    }

    public int getOptionIndex(ActionOption<?> option) {
        for (int i = 0; i < this.options.size(); ++i) {
            if (!this.options.get(i).id().equals((Object)option.id())) continue;
            return i;
        }
        throw new IllegalArgumentException("Option " + String.valueOf(option.id()) + " not found on action " + String.valueOf(this.type));
    }

    public boolean hasMark(long mark) {
        return (this.marks & mark) != 0L;
    }

    @FunctionalInterface
    public static interface CraftActionProvider {
        public AbstractCraftActionContext create(EntityMaid var1, CraftGuideData var2, CraftGuideStepData var3, CraftLayer var4);
    }

    @FunctionalInterface
    public static interface CraftActionPathFindingTargetProvider {
        public BlockPos find(EntityMaid var1, CraftGuideData var2, CraftGuideStepData var3, CraftLayer var4, MaidPathFindingBFS var5);
    }

    public static enum PathEnoughLevel {
        NORMAL(2.0),
        CLOSER(1.2),
        VERY_CLOSE(0.8);

        public final double value;

        private PathEnoughLevel(double value) {
            this.value = value;
        }
    }
}

