/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.context.special;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import studio.fantasyit.maid_storage_manager.craft.WorkBlockTags;
import studio.fantasyit.maid_storage_manager.craft.context.AbstractCraftActionContext;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.RecipeUtil;

public class CraftingRecipeAction
extends AbstractCraftActionContext {
    public static final ResourceLocation TYPE = new ResourceLocation("maid_storage_manager", "craft");

    public CraftingRecipeAction(EntityMaid maid, CraftGuideData craftGuideData, CraftGuideStepData craftGuideStepData, CraftLayer layer) {
        super(maid, craftGuideData, craftGuideStepData, layer);
    }

    @Override
    public AbstractCraftActionContext.Result start() {
        if (this.craftGuideStepData.getStorage() == null) {
            return AbstractCraftActionContext.Result.FAIL;
        }
        return AbstractCraftActionContext.Result.CONTINUE;
    }

    @Override
    public AbstractCraftActionContext.Result tick() {
        Level level = this.maid.m_9236_();
        if (!level.m_8055_(this.craftGuideStepData.storage.pos).m_204336_(WorkBlockTags.CRAFTING_TABLE)) {
            return AbstractCraftActionContext.Result.NOT_DONE;
        }
        CombinedInvWrapper inv = this.maid.getAvailableInv(false);
        List<ItemStack> input = this.craftGuideStepData.getInput();
        List<ItemStack> output = this.craftGuideStepData.getOutput();
        ArrayList<ItemStack> realInput = new ArrayList<ItemStack>();
        int[] slotExtractCount = new int[inv.getSlots()];
        Arrays.fill(slotExtractCount, 0);
        boolean allMatch = true;
        for (int i = 0; i < input.size(); ++i) {
            boolean found = false;
            if (input.get(i).m_41619_()) {
                realInput.add(ItemStack.f_41583_);
                continue;
            }
            for (int j = 0; j < inv.getSlots(); ++j) {
                if (!ItemStack.m_41656_((ItemStack)inv.getStackInSlot(j), (ItemStack)input.get(i)) || inv.getStackInSlot(j).m_41613_() <= slotExtractCount[j]) continue;
                realInput.add(inv.getStackInSlot(j).m_255036_(input.get(i).m_41613_()));
                found = true;
                int n = j;
                slotExtractCount[n] = slotExtractCount[n] + 1;
                break;
            }
            if (found) continue;
            allMatch = false;
            break;
        }
        if (allMatch) {
            CraftingContainer container = RecipeUtil.wrapCraftingContainer(realInput, 3, 3);
            Optional<CraftingRecipe> recipe = RecipeUtil.getCraftingRecipe(level, container);
            if (recipe.isPresent()) {
                int maxCanPlace;
                ItemStack result = recipe.get().m_5874_((Container)container, level.m_9598_());
                if (ItemStackUtil.isSameInCrafting(result, output.get(0))) {
                    this.craftLayer.addCurrentStepPlacedCounts(0, result.m_41613_());
                }
                if ((maxCanPlace = InvUtil.maxCanPlace((IItemHandler)inv, result)) >= result.m_41613_()) {
                    InvUtil.tryPlace((IItemHandler)inv, result);
                    for (int j = 0; j < inv.getSlots(); ++j) {
                        inv.extractItem(j, slotExtractCount[j], false);
                    }
                    NonNullList remain = recipe.get().m_7457_((Container)container);
                    for (int j = 0; j < remain.size(); ++j) {
                        ItemStack itemStack;
                        if (((ItemStack)remain.get(j)).m_41619_()) continue;
                        int total = ((ItemStack)remain.get(j)).m_41613_();
                        for (int k = 0; k < output.size(); ++k) {
                            int rem = output.get(k).m_41613_() - this.craftLayer.getCurrentStepCount(k);
                            if (ItemStackUtil.isSameInCrafting((ItemStack)remain.get(j), output.get(k)) && rem > 0) {
                                this.craftLayer.addCurrentStepPlacedCounts(k, Math.min(total, rem));
                            }
                            if ((total -= rem) <= 0) break;
                        }
                        if ((itemStack = InvUtil.tryPlace((IItemHandler)inv, (ItemStack)remain.get(j))).m_41619_()) continue;
                        InvUtil.throwItem(this.maid, itemStack);
                        return AbstractCraftActionContext.Result.FAIL;
                    }
                    return AbstractCraftActionContext.Result.SUCCESS;
                }
                return AbstractCraftActionContext.Result.FAIL;
            }
        } else {
            return AbstractCraftActionContext.Result.FAIL;
        }
        return AbstractCraftActionContext.Result.FAIL;
    }

    @Override
    public void stop() {
    }
}

