/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.logistics.input;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftResultContext;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.items.LogisticsGuide;
import studio.fantasyit.maid_storage_manager.maid.ChatTexts;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.maid.memory.LogisticsMemory;
import studio.fantasyit.maid_storage_manager.maid.memory.ViewedInventoryMemory;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.StorageVisitLock;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.storage.base.IMaidStorage;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageContext;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageExtractableContext;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageInteractContext;
import studio.fantasyit.maid_storage_manager.util.BehaviorBreath;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;
import studio.fantasyit.maid_storage_manager.util.ViewedInventoryUtil;

public class LogisticsInputBehavior
extends Behavior<EntityMaid> {
    BehaviorBreath breath = new BehaviorBreath();
    CraftLayer layer;
    CraftLayer output;
    IStorageContext context;
    IStorageContext contextView;
    private Target target;
    int failCount = 0;
    StorageVisitLock.LockContext lock;

    public LogisticsInputBehavior() {
        super(Map.of());
    }

    protected boolean canStillUse(ServerLevel level, EntityMaid maid, long p_22547_) {
        if (MemoryUtil.getCurrentlyWorking(maid) != ScheduleBehavior.Schedule.LOGISTICS) {
            return false;
        }
        if (!MemoryUtil.getLogistics(maid).shouldWork()) {
            return false;
        }
        if (MemoryUtil.getLogistics(maid).getStage() != LogisticsMemory.Stage.INPUT) {
            return false;
        }
        if (this.context == null || this.contextView == null) {
            return false;
        }
        if (this.layer != null) {
            if (!this.layer.hasCollectedAll()) {
                if (this.context != null && this.context.isDone()) {
                    this.context.reset();
                    ++this.failCount;
                    return this.failCount <= Config.maxLogisticsTries;
                }
                return true;
            }
            return false;
        }
        if (this.failCount > Config.maxLogisticsTries) {
            return false;
        }
        return !this.context.isDone();
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull EntityMaid maid) {
        if (MemoryUtil.getCurrentlyWorking(maid) != ScheduleBehavior.Schedule.LOGISTICS) {
            return false;
        }
        if (MemoryUtil.getLogistics(maid).getCurrentLogisticsGuideItem().m_41619_()) {
            return false;
        }
        if (MemoryUtil.getLogistics(maid).getStage() != LogisticsMemory.Stage.INPUT) {
            return false;
        }
        return Conditions.hasReachedValidTargetOrReset(maid);
    }

    protected void start(@NotNull ServerLevel level, @NotNull EntityMaid maid, long gameTimeIn) {
        this.lock = StorageVisitLock.DUMMY;
        this.target = MemoryUtil.getLogistics(maid).getTarget();
        IMaidStorage storage = MaidStorage.getInstance().getStorage(this.target.getType());
        if (storage == null) {
            return;
        }
        this.contextView = storage.onStartView(level, maid, this.target);
        this.failCount = 0;
        this.layer = null;
        this.output = null;
        if (this.contextView == null) {
            return;
        }
        this.contextView.start(maid, level, this.target);
        this.context = storage.onStartCollect(level, maid, this.target);
        if (this.context != null) {
            this.context.start(maid, level, this.target);
        }
        MemoryUtil.getViewedInventory(maid).resetViewedInvForPos(this.target);
        StorageAccessUtil.checkNearByContainers((Level)level, this.target.getPos(), pos -> MemoryUtil.getViewedInventory(maid).resetViewedInvForPosAsRemoved(this.target.sameType((BlockPos)pos, null)));
        this.lock = StorageVisitLock.getReadLock(this.target);
    }

    protected void tick(ServerLevel level, EntityMaid maid, long p_22553_) {
        if (this.context == null || this.contextView == null) {
            return;
        }
        if (!this.lock.checkAndTryGrantLock()) {
            return;
        }
        if (!this.contextView.isDone()) {
            this.tickView(level, maid, p_22553_);
        } else if (this.layer == null) {
            this.calculateLayer(level, maid);
        } else if (this.layer != null) {
            this.tickGathering(level, maid, p_22553_);
        }
    }

    private void calculateLayer(ServerLevel level, EntityMaid maid) {
        ItemStack currentLogisticsGuideItem = MemoryUtil.getLogistics(maid).getCurrentLogisticsGuideItem();
        CraftGuideData craftGuideData = LogisticsGuide.getCraftGuideData(currentLogisticsGuideItem);
        List<ViewedInventoryMemory.ItemCount> itemsAt = MemoryUtil.getViewedInventory(maid).getItemsAt(this.target).stream().filter(itemCount -> !itemCount.item().m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get()) && !itemCount.item().m_41619_()).toList();
        ItemStack filterItemStack = LogisticsGuide.getFilterItemStack(currentLogisticsGuideItem);
        if (!filterItemStack.m_41619_()) {
            ArrayList<ItemStack> filteredItems = new ArrayList<ItemStack>();
            CompoundTag t = filterItemStack.m_41784_();
            ListTag list = t.m_128437_("items", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag tmp = list.m_128728_(i);
                ItemStack item = ItemStackUtil.parseStack(tmp.m_128469_("item"));
                filteredItems.add(item);
            }
            boolean matchNbt = t.m_128471_("match_tag");
            boolean isBlackMode = t.m_128471_("black_mode");
            itemsAt = itemsAt.stream().filter(itemCount -> {
                boolean match = filteredItems.stream().anyMatch(itemStack -> ItemStackUtil.isSame(itemStack, itemCount.item(), matchNbt));
                return match != isBlackMode;
            }).toList();
        }
        int count = LogisticsGuide.getWorkCount(currentLogisticsGuideItem);
        if (craftGuideData != null) {
            if ((count = this.getAvailableCountFromCraftAndSetLayer(maid, craftGuideData, itemsAt, count)) == 0) {
                this.lock.release();
                this.lock = StorageVisitLock.getReadLock(this.target);
                this.contextView.reset();
                MemoryUtil.getViewedInventory(maid).resetViewedInvForPos(this.target);
                ++this.failCount;
                this.layer = null;
                this.output = null;
            }
        } else if (!itemsAt.isEmpty()) {
            ViewedInventoryMemory.ItemCount itemCount2 = itemsAt.get(0);
            ItemStack itemStack = itemCount2.item();
            itemStack = count == 64 ? itemStack.m_255036_(Math.min(itemCount2.count(), itemStack.m_41741_())) : itemStack.m_255036_(1);
            this.layer = new CraftLayer(Optional.empty(), List.of(itemStack), 1);
            this.output = new CraftLayer(Optional.empty(), List.of(itemStack), 1);
        } else {
            this.contextView.reset();
            MemoryUtil.getViewedInventory(maid).resetViewedInvForPos(this.target);
            ++this.failCount;
        }
        if (!MemoryUtil.getLogistics(maid).hasMultipleGuide(maid)) {
            this.failCount = 0;
        }
    }

    private int getAvailableCountFromCraftAndSetLayer(EntityMaid maid, CraftGuideData craftGuideData, List<ViewedInventoryMemory.ItemCount> itemsAt, int count) {
        List<ItemStack> inputs = craftGuideData.getInput();
        List<ItemStack> costedInputs = inputs.stream().map(ItemStack::m_41777_).toList();
        block0: for (ItemStack output : craftGuideData.getOutput()) {
            int outputCount = output.m_41613_();
            for (ItemStack itemStack2 : costedInputs) {
                if (!itemStack2.m_41619_() && ItemStackUtil.isSame(output, itemStack2, false)) {
                    int remove = Math.min(outputCount, itemStack2.m_41613_());
                    itemStack2.m_41774_(remove);
                    outputCount -= remove;
                }
                if (outputCount > 0) continue;
                continue block0;
            }
        }
        for (int i = 0; i < inputs.size(); ++i) {
            ItemStack input = inputs.get(i);
            ItemStack costedInput = costedInputs.get(i);
            int availableCount = 0;
            for (ViewedInventoryMemory.ItemCount itemCount : itemsAt) {
                if (!ItemStackUtil.isSame(input, itemCount.item(), false)) continue;
                availableCount += itemCount.getSecond();
            }
            if (availableCount < input.m_41613_()) {
                count = 0;
                continue;
            }
            if (costedInput.m_41613_() == 0) continue;
            count = Math.min(count, (availableCount - input.m_41613_()) / costedInput.m_41613_() + 1);
        }
        ArrayList<ItemStack> toSimulate = new ArrayList<ItemStack>(inputs.stream().map(ItemStack::m_41777_).toList());
        ArrayList<CraftLayer> toTest = new ArrayList<CraftLayer>();
        CraftLayer test = new CraftLayer(Optional.of(craftGuideData), toSimulate, 1);
        for (int i = 0; i < count; ++i) {
            toTest.add(test);
        }
        while (count > 0) {
            for (int i = 0; i < inputs.size(); ++i) {
                ((ItemStack)toSimulate.get(i)).m_41764_(costedInputs.get(i).m_41613_() * count + inputs.get(i).m_41613_());
            }
            CraftResultContext context = new CraftResultContext(toTest);
            if (context.getSlotConsume() < InvUtil.freeSlots((IItemHandler)maid.getAvailableInv(false))) break;
            toTest.remove(0);
            --count;
        }
        if (count == 0) {
            return 0;
        }
        for (int i = 0; i < inputs.size(); ++i) {
            if (count <= 1) {
                ((ItemStack)toSimulate.get(i)).m_41764_(inputs.get(i).m_41613_());
                continue;
            }
            ((ItemStack)toSimulate.get(i)).m_41764_(costedInputs.get(i).m_41613_() * (count - 1) + inputs.get(i).m_41613_());
        }
        this.layer = new CraftLayer(Optional.of(craftGuideData), toSimulate, count);
        CraftResultContext remainContext = new CraftResultContext(toTest);
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        remainContext.forEachRemaining((itemStack, c) -> ItemStackUtil.addToList((List<ItemStack>)remains, itemStack.m_255036_(c.intValue()), false));
        this.output = new CraftLayer(Optional.empty(), arrayList, count);
        return count;
    }

    private void tickView(ServerLevel level, EntityMaid maid, long p22553) {
        IStorageContext iStorageContext = this.contextView;
        if (iStorageContext instanceof IStorageInteractContext) {
            IStorageInteractContext isic = (IStorageInteractContext)iStorageContext;
            isic.tick(itemStack -> {
                MemoryUtil.getViewedInventory(maid).addItem(this.target, (ItemStack)itemStack);
                return itemStack;
            });
        }
    }

    protected void tickGathering(ServerLevel level, EntityMaid maid, long p_22553_) {
        Function<ItemStack, ItemStack> taker = itemStack -> {
            int maxStore = InvUtil.maxCanPlace((IItemHandler)maid.getAvailableInv(false), itemStack);
            if (maxStore > 0) {
                ItemStack copy = itemStack.m_41777_();
                ItemStack toTake = this.layer.memorizeItem((ItemStack)itemStack, maxStore);
                if (toTake.m_41613_() > 0) {
                    ChatTexts.send(maid, (Component)Component.m_237110_((String)"chat_bubbles.maid_storage_manager.moving_taken", (Object[])new Object[]{itemStack.m_41786_(), String.valueOf(toTake.m_41613_())}));
                }
                copy.m_41774_(toTake.m_41613_());
                ViewedInventoryUtil.ambitiousRemoveItemAndSync(maid, level, this.target, itemStack, toTake.m_41613_());
                InvUtil.tryPlace((IItemHandler)maid.getAvailableInv(false), toTake);
                return copy;
            }
            return itemStack;
        };
        IStorageContext iStorageContext = this.context;
        if (iStorageContext instanceof IStorageInteractContext) {
            IStorageInteractContext isic = (IStorageInteractContext)iStorageContext;
            isic.tick(taker);
        } else {
            iStorageContext = this.context;
            if (iStorageContext instanceof IStorageExtractableContext) {
                IStorageExtractableContext isec = (IStorageExtractableContext)iStorageContext;
                if (isec.hasTask()) {
                    isec.tick(taker);
                } else {
                    isec.setExtract(this.layer.getUnCollectedItems(), ItemStackUtil.MATCH_TYPE.AUTO);
                }
            }
        }
    }

    protected void stop(ServerLevel level, EntityMaid maid, long p_22550_) {
        this.lock.release();
        super.m_6732_(level, (LivingEntity)maid, p_22550_);
        if (this.contextView != null) {
            this.contextView.finish();
            if (this.contextView.isDone()) {
                Target target = MemoryUtil.getCrafting(maid).getTarget();
                MemoryUtil.getCrafting(maid).addVisitedPos(target);
                StorageAccessUtil.checkNearByContainers((Level)level, target.getPos(), pos -> MemoryUtil.getCrafting(maid).addVisitedPos(target.sameType((BlockPos)pos, null)));
            }
        }
        if (this.context != null) {
            this.context.finish();
        }
        if (this.layer != null && this.output != null) {
            if (this.layer.getCollectedCounts().stream().anyMatch(i -> i > 0)) {
                MemoryUtil.getLogistics(maid).setCraftAndResultLayer(this.layer, this.output);
                if (this.layer.getCraftData().isPresent()) {
                    MemoryUtil.getLogistics(maid).setStage(LogisticsMemory.Stage.CRAFT);
                    if (!this.layer.getItems().isEmpty()) {
                        ChatTexts.send(maid, (Component)Component.m_237110_((String)"chat_bubbles.maid_storage_manager.crafting", (Object[])new Object[]{this.layer.getItems().get(0).m_41786_()}));
                    }
                } else {
                    MemoryUtil.getLogistics(maid).setStage(LogisticsMemory.Stage.OUTPUT);
                    if (!this.layer.getItems().isEmpty()) {
                        ChatTexts.send(maid, (Component)Component.m_237110_((String)"chat_bubbles.maid_storage_manager.moving", (Object[])new Object[]{this.layer.getItems().get(0).m_41786_()}));
                    }
                }
            }
        } else {
            MemoryUtil.getLogistics(maid).setStage(LogisticsMemory.Stage.FINISH);
        }
        if (StorageAccessUtil.findTargetRewrite(level, maid, this.target, false).isEmpty()) {
            MemoryUtil.getViewedInventory(maid).resetViewedInvForPosAsRemoved(this.target);
        }
        MemoryUtil.getLogistics(maid).clearTarget();
        MemoryUtil.clearTarget(maid);
    }

    protected boolean m_7773_(long p_22537_) {
        return false;
    }
}

