/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.request.stock;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.item.ItemStack;
import studio.fantasyit.maid_storage_manager.items.RequestListItem;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.StorageVisitLock;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageContext;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageInteractContext;
import studio.fantasyit.maid_storage_manager.util.BehaviorBreath;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;

public class StockCheckBehavior
extends Behavior<EntityMaid> {
    private final BehaviorBreath breath = new BehaviorBreath();
    IStorageContext context;
    private Target target;
    StorageVisitLock.LockContext lock = StorageVisitLock.DUMMY;

    public StockCheckBehavior() {
        super(Map.of());
    }

    protected boolean checkExtraStartConditions(ServerLevel p_22538_, EntityMaid maid) {
        if (MemoryUtil.getCurrentlyWorking(maid) != ScheduleBehavior.Schedule.REQUEST) {
            return false;
        }
        if (!MemoryUtil.getRequestProgress(maid).isCheckingStock()) {
            return false;
        }
        return Conditions.hasReachedValidTargetOrReset(maid);
    }

    protected boolean canStillUse(ServerLevel p_22545_, EntityMaid maid, long p_22547_) {
        if (MemoryUtil.getCurrentlyWorking(maid) != ScheduleBehavior.Schedule.REQUEST) {
            return false;
        }
        return this.context != null && !this.context.isDone();
    }

    protected void start(ServerLevel level, EntityMaid maid, long p_22542_) {
        this.lock = StorageVisitLock.DUMMY;
        if (!MemoryUtil.getRequestProgress(maid).hasTarget()) {
            return;
        }
        this.target = MemoryUtil.getRequestProgress(maid).getTarget();
        this.context = MaidStorage.getInstance().getStorage(this.target.type).onStartView(level, maid, this.target);
        if (this.context != null) {
            this.context.start(maid, level, this.target);
        }
        this.lock = StorageVisitLock.getReadLock(this.target);
    }

    protected void tick(ServerLevel p_22551_, EntityMaid maid, long p_22553_) {
        if (!this.lock.checkAndTryGrantLock()) {
            return;
        }
        if (!this.breath.breathTick(maid)) {
            return;
        }
        super.m_6725_(p_22551_, (LivingEntity)maid, p_22553_);
        IStorageContext iStorageContext = this.context;
        if (iStorageContext instanceof IStorageInteractContext) {
            IStorageInteractContext isic = (IStorageInteractContext)iStorageContext;
            isic.tick(itemStack -> {
                ItemStack rest = RequestListItem.updateCollectedItem(maid.m_21205_(), itemStack.m_41777_(), itemStack.m_41613_(), false);
                if (rest.m_41613_() != itemStack.m_41613_()) {
                    RequestListItem.updateStored(maid.m_21205_(), itemStack.m_255036_(itemStack.m_41613_() - rest.m_41613_()), false, false);
                }
                return itemStack;
            });
        }
    }

    protected void stop(ServerLevel level, EntityMaid maid, long p_22550_) {
        this.lock.release();
        if (this.context != null) {
            this.context.finish();
        }
        MemoryUtil.getRequestProgress(maid).addVisitedPos(this.target);
        MemoryUtil.getRequestProgress(maid).setCheckingStock(false);
        MemoryUtil.getViewedInventory(maid).clearTarget();
        MemoryUtil.clearTarget(maid);
        RequestListItem.setHasCheckedStock(maid.m_21205_(), true);
    }
}

