/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.memory;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.storage.Target;

public abstract class AbstractTargetMemory {
    private int failCount;
    private int pathFindingFailCount;
    public TargetData targetData;

    public TargetData getTargetData() {
        return this.targetData;
    }

    public AbstractTargetMemory(TargetData targetData) {
        this.targetData = targetData;
        this.failCount = 0;
    }

    public AbstractTargetMemory() {
        this.targetData = new TargetData(new ArrayList<Target>(), new Target(TargetData.NO_TARGET, BlockPos.f_121853_, Optional.empty()));
    }

    public List<Target> getVisitedPos() {
        return this.targetData.visitedPos;
    }

    public void addVisitedPos(Target pos) {
        if (this.isVisitedPos(pos)) {
            return;
        }
        this.targetData.visitedPos.add(pos);
    }

    public void resetVisitedPos() {
        this.targetData.visitedPos.clear();
    }

    public void removeVisitedPos(Target pos) {
        this.targetData.visitedPos.remove(pos);
    }

    public boolean isVisitedPos(Target pos) {
        return this.targetData.visitedPos.contains(pos);
    }

    public int getFailCount() {
        return this.failCount;
    }

    public void addFailCount() {
        ++this.failCount;
    }

    public void resetFailCount() {
        this.failCount = 0;
    }

    public boolean confirmNoTarget() {
        return this.confirmNoTarget(30);
    }

    public boolean confirmNoTarget(int threshold) {
        this.addFailCount();
        return this.failCount >= threshold;
    }

    public Target getTarget() {
        return this.targetData.getTarget();
    }

    public void setTarget(Target target) {
        this.targetData.setTarget(target);
    }

    public void clearTarget() {
        this.targetData.setTarget(new Target(TargetData.NO_TARGET, BlockPos.f_121853_, Optional.empty()));
    }

    public boolean hasTarget() {
        return !this.targetData.getTarget().type.equals((Object)TargetData.NO_TARGET);
    }

    public void setCheckItem(ItemStack checkItem) {
        this.targetData.checkItem = checkItem;
    }

    public void clearCheckItem() {
        this.targetData.checkItem = null;
    }

    public ItemStack getCheckItem() {
        return this.targetData.checkItem != null ? this.targetData.checkItem : ItemStack.f_41583_;
    }

    public static class TargetData {
        public static final Codec<TargetData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(Target.CODEC).fieldOf("visitedPos").forGetter(TargetData::getVisitedPos), (App)Target.CODEC.fieldOf("target").forGetter(TargetData::getTarget), (App)ItemStack.f_41582_.optionalFieldOf("check").forGetter(TargetData::getCheckItem)).apply((Applicative)instance, TargetData::new));
        public static ResourceLocation NO_TARGET = new ResourceLocation("maid_storage_manager", "no_target");
        public List<Target> visitedPos;
        public Target target;
        @Nullable
        public ItemStack checkItem;

        public TargetData(List<Target> visitedPos, Target target) {
            this(visitedPos, target, Optional.empty());
        }

        public TargetData(List<Target> visitedPos, Target target, Optional<ItemStack> checkItem) {
            this.visitedPos = new ArrayList<Target>(visitedPos);
            this.target = target;
            this.checkItem = checkItem.orElse(null);
            if (target == null) {
                this.target = new Target(NO_TARGET, BlockPos.f_121853_, Optional.empty());
            }
        }

        public List<Target> getVisitedPos() {
            return this.visitedPos;
        }

        public Target getTarget() {
            return this.target;
        }

        public void setTarget(Target target) {
            this.target = target;
        }

        public Optional<ItemStack> getCheckItem() {
            return Optional.ofNullable(this.checkItem);
        }
    }
}

