/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.memory;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayerChain;
import studio.fantasyit.maid_storage_manager.items.RequestListItem;
import studio.fantasyit.maid_storage_manager.maid.ChatTexts;
import studio.fantasyit.maid_storage_manager.maid.memory.AbstractTargetMemory;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;

public class CraftMemory
extends AbstractTargetMemory {
    public static Codec<CraftMemory> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)AbstractTargetMemory.TargetData.CODEC.fieldOf("targetData").forGetter(AbstractTargetMemory::getTargetData), (App)CraftGuideData.CODEC.listOf().fieldOf("craftGuides").forGetter(CraftMemory::getCraftGuides), (App)Codec.BOOL.fieldOf("goPlacingBeforeCraft").forGetter(CraftMemory::isGoPlacingBeforeCraft), (App)CraftLayerChain.CODEC.optionalFieldOf("craftPlan").forGetter(t -> Optional.ofNullable(t.plan)), (App)Target.CODEC.listOf().fieldOf("ignoreTargets").orElse(List.of()).forGetter(CraftMemory::getIgnoreTargets), (App)Codec.BOOL.fieldOf("isGatheringDispatched").forGetter(CraftMemory::isGatheringDispatched)).apply((Applicative)instance, CraftMemory::new));
    public CraftLayerChain plan;
    public List<CraftGuideData> craftGuides;
    public boolean goPlacingBeforeCraft;
    private int pathFindingFailCount = 0;
    private List<Target> ignoreTargets;
    private boolean isGatheringDispatched;
    public int calculatingTotal = -1;
    public int calculatingProgress = -1;
    boolean isSwappingHandWhenCrafting = false;

    public CraftMemory(AbstractTargetMemory.TargetData targetData, List<CraftGuideData> craftGuides, boolean goPlacingBeforeCraft, Optional<CraftLayerChain> plan, List<Target> ignoreTargets, boolean isGatheringDispatched) {
        super(targetData);
        this.craftGuides = new ArrayList<CraftGuideData>(craftGuides);
        this.goPlacingBeforeCraft = goPlacingBeforeCraft;
        this.plan = plan.orElse(null);
        this.ignoreTargets = new ArrayList<Target>(ignoreTargets);
        this.isGatheringDispatched = isGatheringDispatched;
    }

    public CraftMemory() {
        this.craftGuides = new ArrayList<CraftGuideData>();
        this.goPlacingBeforeCraft = false;
        this.plan = null;
        this.ignoreTargets = new ArrayList<Target>();
        this.isGatheringDispatched = false;
    }

    public void setPlan(CraftLayerChain plan) {
        this.plan = plan;
        if (!plan.freeze) {
            plan.build();
        }
        if (!plan.isMaster()) {
            this.isGatheringDispatched = true;
        }
        this.calculatingTotal = -1;
        this.calculatingProgress = -1;
    }

    public void clearPlan() {
        this.plan = null;
        this.isGatheringDispatched = false;
        this.calculatingTotal = -1;
        this.calculatingProgress = -1;
    }

    public boolean hasPlan() {
        return this.plan != null;
    }

    public CraftLayerChain plan() {
        return this.plan;
    }

    public void stopAndClearPlan(EntityMaid maid) {
        this.setGoPlacingBeforeCraft(true);
        ChatTexts.send(maid, "chat_bubbles.maid_storage_manager.crafting_reschedule");
        ChatTexts.removeSecondary(maid);
        this.clearPlan();
        MemoryUtil.getRequestProgress(maid).setReturn(false);
    }

    public void initPreLayer() {
        this.isSwappingHandWhenCrafting = false;
    }

    public boolean isGatheringDispatched() {
        return this.isGatheringDispatched;
    }

    public void setGatheringDispatched(boolean isGatheringDispatched) {
        this.isGatheringDispatched = isGatheringDispatched;
    }

    public List<CraftGuideData> getCraftGuides() {
        return this.craftGuides;
    }

    public void addCraftGuide(CraftGuideData craftGuideData) {
        if (!craftGuideData.available()) {
            return;
        }
        this.craftGuides.add(craftGuideData);
    }

    public void clearCraftGuides() {
        this.craftGuides.clear();
    }

    public boolean isGoPlacingBeforeCraft() {
        return this.goPlacingBeforeCraft;
    }

    public void setGoPlacingBeforeCraft(boolean goPlacingBeforeCraft) {
        this.goPlacingBeforeCraft = goPlacingBeforeCraft;
    }

    public void lastSuccess() {
        this.goPlacingBeforeCraft = true;
    }

    public void resetAndMarkVis(ServerLevel level, EntityMaid maid) {
        this.resetVisitedPos();
        for (Target target : this.getIgnoreTargets()) {
            this.addVisitedPos(target);
        }
    }

    public boolean isSwappingHandWhenCrafting() {
        return this.isSwappingHandWhenCrafting;
    }

    public void setSwappingHandWhenCrafting(boolean isSwappingHandWhenCrafting) {
        this.isSwappingHandWhenCrafting = isSwappingHandWhenCrafting;
    }

    public int getPathFindingFailCount() {
        return this.pathFindingFailCount;
    }

    public void addPathFindingFailCount() {
        ++this.pathFindingFailCount;
    }

    public void resetPathFindingFailCount() {
        this.pathFindingFailCount = 0;
    }

    public List<Target> getIgnoreTargets() {
        return this.ignoreTargets;
    }

    public void addIgnoreTargets(Target ignoreTargets) {
        this.ignoreTargets.add(ignoreTargets);
    }

    public void addIgnoreTargets(List<Target> ignoreTargets) {
        this.ignoreTargets.addAll(ignoreTargets);
    }

    public void clearIgnoreTargets() {
        this.ignoreTargets.clear();
    }

    public void addIgnoreTargetFromRequest(EntityMaid maid, ServerLevel level) {
        Target storageBlock = RequestListItem.getStorageBlock(maid.m_21205_());
        if (storageBlock != null) {
            this.clearIgnoreTargets();
            this.addIgnoreTargets(storageBlock);
            StorageAccessUtil.checkNearByContainers((Level)level, storageBlock.getPos(), pos -> this.addIgnoreTargets(storageBlock.sameType((BlockPos)pos, null)));
        }
    }

    public void tryStartIfHasPlan() {
        if (this.hasPlan()) {
            this.plan.startAny();
        }
    }
}

