/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.storage;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.integration.Integrations;
import studio.fantasyit.maid_storage_manager.maid.memory.ViewedInventoryMemory;
import studio.fantasyit.maid_storage_manager.storage.CollectStorageEvent;
import studio.fantasyit.maid_storage_manager.storage.ItemHandler.ItemHandlerStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.storage.ae2.Ae2Storage;
import studio.fantasyit.maid_storage_manager.storage.base.IMaidStorage;
import studio.fantasyit.maid_storage_manager.storage.create.place.CreateChainConveyorStorage;
import studio.fantasyit.maid_storage_manager.storage.create.stock.CreateStockTickerStorage;
import studio.fantasyit.maid_storage_manager.storage.qio.QIOStorage;
import studio.fantasyit.maid_storage_manager.storage.rs.RSStorage;

public class MaidStorage {
    public static MaidStorage instance = null;
    List<IMaidStorage> storages;

    public static MaidStorage getInstance() {
        if (instance == null) {
            instance = new MaidStorage();
        }
        return instance;
    }

    public void collectStorage() {
        ArrayList<IMaidStorage> list = new ArrayList<IMaidStorage>();
        if (Integrations.ae2Storage()) {
            list.add(new Ae2Storage());
        }
        if (Integrations.rsStorage()) {
            list.add(new RSStorage());
        }
        if (Integrations.createStorage()) {
            list.add(new CreateStockTickerStorage());
            list.add(new CreateChainConveyorStorage());
        }
        if (Integrations.mekanismStorage()) {
            list.add(new QIOStorage());
        }
        list.add(new ItemHandlerStorage());
        CollectStorageEvent event = new CollectStorageEvent(list);
        ModLoader.get().postEvent((Event)event);
        this.storages = event.getStorages();
    }

    @Nullable
    public Target isValidTarget(ServerLevel level, LivingEntity maid, Target target) {
        BlockState blockState = level.m_8055_(target.pos);
        if (blockState.m_60713_(Blocks.f_50016_)) {
            return null;
        }
        BlockEntity blockEntity = level.m_7702_(target.pos);
        ResourceLocation type = target.getType();
        for (IMaidStorage storage : this.storages) {
            if (!storage.getType().equals((Object)type) || !storage.isValidTarget(level, maid, target.pos, target.side, blockState, blockEntity)) continue;
            return target;
        }
        return null;
    }

    @Nullable
    public Target isValidTarget(ServerLevel level, LivingEntity maid, BlockPos block) {
        return this.isValidTarget(level, maid, block, null);
    }

    @Nullable
    public Target isValidTarget(ServerLevel level, LivingEntity maid, BlockPos block, Direction side) {
        BlockState blockState = level.m_8055_(block);
        if (blockState.m_60795_()) {
            return null;
        }
        BlockEntity blockEntity = level.m_7702_(block);
        for (IMaidStorage storage : this.storages) {
            if (!storage.isValidTarget(level, maid, block, side, blockState, blockEntity)) continue;
            return new Target(storage.getType(), block, side);
        }
        return null;
    }

    @Nullable
    public IMaidStorage getStorage(ResourceLocation type) {
        for (IMaidStorage storage : this.storages) {
            if (!storage.getType().equals((Object)type)) continue;
            return storage;
        }
        return null;
    }

    public boolean isCraftGuideProvider(Target target, List<ViewedInventoryMemory.ItemCount> blockPos) {
        IMaidStorage storage = this.getStorage(target.type);
        if (storage == null) {
            return false;
        }
        return storage.isCraftGuideProvider(blockPos);
    }
}

