/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.storage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class Target {
    public static final ResourceLocation VIRTUAL_TYPE = new ResourceLocation("maid_storage_manager", "virtual");
    public static Codec<Target> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("type").forGetter(Target::getType), (App)BlockPos.f_121852_.fieldOf("pos").forGetter(Target::getPos), (App)Direction.f_175356_.optionalFieldOf("side").forGetter(Target::getSide)).apply((Applicative)instance, Target::new));
    public ResourceLocation type;
    public BlockPos pos;
    @Nullable
    public Direction side;

    public Target(ResourceLocation type, BlockPos pos) {
        this(type, pos, Optional.empty());
    }

    public Target(ResourceLocation type, BlockPos pos, Optional<Direction> side) {
        this(type, pos, (Direction)side.orElse(null));
    }

    public Target(ResourceLocation type, BlockPos pos, @Nullable Direction side) {
        this.type = type;
        this.pos = pos;
        this.side = side;
    }

    public static Target fromNbt(CompoundTag nbt) {
        if (!nbt.m_128441_("side")) {
            return new Target(new ResourceLocation(nbt.m_128461_("type")), BlockPos.m_122022_((long)nbt.m_128454_("pos")), Optional.empty());
        }
        return new Target(new ResourceLocation(nbt.m_128461_("type")), BlockPos.m_122022_((long)nbt.m_128454_("pos")), Direction.m_122402_((String)nbt.m_128461_("side")));
    }

    @Nullable
    public static Target fromStoreString(String str) {
        String[] split = str.split(",");
        if (split.length == 4 || split.length == 5) {
            return new Target(new ResourceLocation(split[0]), new BlockPos(Integer.parseInt(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3])), split.length == 5 ? Direction.m_122402_((String)split[4]) : null);
        }
        return null;
    }

    public static Target virtual(BlockPos clickedPos, @Nullable Direction clickedFace) {
        return new Target(VIRTUAL_TYPE, clickedPos, clickedFace);
    }

    public Target sameType(BlockPos pos, @Nullable Direction side) {
        return new Target(this.type, pos, side);
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("type", this.type.toString());
        nbt.m_128356_("pos", this.pos.m_121878_());
        if (this.side != null) {
            nbt.m_128359_("side", this.side.m_122433_());
        }
        return nbt;
    }

    public ResourceLocation getType() {
        return this.type;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Optional<Direction> getSide() {
        return Optional.ofNullable(this.side);
    }

    public String toString() {
        return String.format("Storage[%s]at{%d,%d,%d}(%s)", this.type.toString(), this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_(), this.side == null ? "" : this.side.m_122433_());
    }

    public String toStoreString() {
        return String.format("%s,%d,%d,%d,%s", this.type.toString(), this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_(), this.side == null ? "" : this.side.m_122433_());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Target) {
            Target storage = (Target)obj;
            return storage.type.equals((Object)this.type) && storage.pos.equals((Object)this.pos) && storage.side == this.side;
        }
        return false;
    }

    public int hashCode() {
        return this.type.hashCode() * 19 + this.pos.hashCode() * 13 + (this.side == null ? 0 : this.side.hashCode()) * 7;
    }

    public Target withoutSide() {
        return new Target(this.type, this.pos, Optional.empty());
    }

    public BlockState getBlockStateInLevel(Level level) {
        return level.m_8055_(this.pos);
    }
}

