/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.compat.msm.vinery;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import com.github.wallev.maidsoulkitchen.compat.msm.common.autocraftguide.base.AutoCraftGuideGeneratorRegister;
import com.github.wallev.maidsoulkitchen.compat.msm.common.autocraftguide.grape.IGrapeJumpCustomGuideGenerator;
import com.github.wallev.maidsoulkitchen.compat.msm.common.util.lang.TypeLang;
import com.github.wallev.maidsoulkitchen.mixin.compat.vinery.GrapevinePotBlockAccessor;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.github.wallev.maidsoulkitchen.vhelper.client.resources.VResourceLocation;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.vinery.core.block.GrapevinePotBlock;
import net.satisfy.vinery.core.registry.GrapeTypeRegistry;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.util.GrapeType;
import org.jetbrains.annotations.NotNull;

@AutoCraftGuideGeneratorRegister(value=TaskInfo.MSM_VINERY_GRAPE_POT)
public class GeneratorVineryGrapePotGuide
implements IGrapeJumpCustomGuideGenerator<GrapeType> {
    @Override
    public int jumpTime() {
        return 4;
    }

    @Override
    public boolean isValidBlockInWorld(ServerLevel level, EntityMaid maid, BlockPos pos, MaidPathFindingBFS pathFinding) {
        BlockState blockState = level.m_8055_(pos);
        return blockState.m_60734_() instanceof GrapevinePotBlock && this.isEmpty(blockState);
    }

    public boolean isEmpty(BlockState blockState) {
        return (Integer)blockState.m_61143_((Property)GrapevinePotBlockAccessor.msk$getState()) == 0 && (Integer)blockState.m_61143_((Property)GrapevinePotBlockAccessor.msk$getStorage()) == 0;
    }

    @Override
    @TypeLang(en_us="Make grape vine", zh_cn="\u5236\u4f5c\u8461\u8404\u9152(\u8e29\u8461\u8404)")
    @NotNull
    public ResourceLocation getType() {
        return VResourceLocation.createTypeMod("vinery:grape");
    }

    @Override
    public List<Ingredient> getInputs(GrapeType recipe) {
        Item fruit = recipe.getFruit();
        ItemStack itemStack = new ItemStack((ItemLike)fruit, 6);
        return List.of(Ingredient.m_43927_((ItemStack[])new ItemStack[]{itemStack}));
    }

    @Override
    public List<Ingredient> getContainers(GrapeType recipe) {
        ItemStack bottle = ((Item)ObjectRegistry.WINE_BOTTLE.get()).m_7968_();
        bottle.m_41764_(2);
        return List.of(Ingredient.m_43927_((ItemStack[])new ItemStack[]{bottle}));
    }

    @Override
    public List<ItemStack> getOutputs(GrapeType recipe, RegistryAccess registryAccess) {
        ItemStack defaultInstance = recipe.getBottle().m_7968_();
        defaultInstance.m_41764_(2);
        return List.of(defaultInstance);
    }

    @Override
    public Item getBlockItemForTranslate() {
        return ((Block)ObjectRegistry.GRAPEVINE_POT.get()).m_5456_();
    }

    @Override
    public void consumeRecipes(RecipeManager manager, Consumer<GrapeType> recipeConsumer) {
        GrapeTypeRegistry.GRAPE_TYPE_TYPES.forEach(recipeConsumer);
    }

    @Override
    public ResourceLocation getRecipeId(GrapeType recipe) {
        return VResourceLocation.create("vinery:grape/" + recipe.m_7912_());
    }

    public boolean isBlockValid(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60734_() instanceof GrapevinePotBlock;
    }
}

