/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.mutable.MutableInt;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.craft.CraftManager;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.debug.CraftingDebugContext;
import studio.fantasyit.maid_storage_manager.craft.debug.IDebugContextSetter;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.GeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ThreadedGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.cache.GraphCache;
import studio.fantasyit.maid_storage_manager.craft.generator.config.GeneratingConfig;
import studio.fantasyit.maid_storage_manager.craft.generator.type.base.IAutoCraftGuideGenerator;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;

public class AutoGraphGenerator
implements IDebugContextSetter {
    private static final ResourceLocation INTERNAL_TYPE = new ResourceLocation("maid_storage_manager", "_maid_storage_internal_existed");
    private final EntityMaid maid;
    protected final ICachableGeneratorGraph graph;
    protected final List<IAutoCraftGuideGenerator> iAutoCraftGuideGenerators;
    protected final List<InventoryItem> inventory;
    protected MaidPathFindingBFS pathfindingBFS;
    Map<ResourceLocation, List<BlockPos>> recognizedTypePositions;
    Set<ResourceLocation> hasDoneTypes;
    private final List<BlockPos> blockPosList;
    protected int index = 0;
    protected int craftGeneratorTypeIndex = 0;
    protected double currentMinDistance = Double.MAX_VALUE;
    protected BlockPos minPos;
    private CraftingDebugContext debugContext = CraftingDebugContext.Dummy.INSTANCE;
    boolean isProcessingBlocks = true;

    protected ICachableGeneratorGraph getGraph(RegistryAccess registryAccess) {
        return switch (Config.craftingGenerator) {
            default -> throw new IncompatibleClassChangeError();
            case Config.CraftGenerator.RELEVANCE -> new GeneratorGraph(registryAccess);
            case Config.CraftGenerator.RELEVANCE_THREADED -> new ThreadedGeneratorGraph(registryAccess);
        };
    }

    protected void updatePathfinding() {
        int distance = (int)Math.ceil(this.maid.m_21536_() ? (double)this.maid.m_21535_() : 5.0);
        this.pathfindingBFS = new MaidPathFindingBFS(this.maid.m_21573_().m_26575_(), (ServerLevel)this.maid.m_9236_(), this.maid, (float)distance, 7);
    }

    public AutoGraphGenerator(EntityMaid maid, List<ItemStack> itemList, List<CraftGuideData> hasExisted) {
        this.maid = maid;
        BlockPos center = maid.m_20183_();
        if (maid.m_21536_()) {
            center = maid.m_21534_();
        }
        int distance = (int)Math.ceil(maid.m_21536_() ? (double)maid.m_21535_() : 5.0);
        this.updatePathfinding();
        this.inventory = MemoryUtil.getViewedInventory(maid).flatten();
        this.iAutoCraftGuideGenerators = CraftManager.getInstance().getAutoCraftGuideGenerators();
        this.blockPosList = BlockPos.m_121921_((AABB)new AABB(center).m_82377_((double)distance, 6.0, (double)distance)).map(BlockPos::m_7949_).filter(arg_0 -> ((EntityMaid)maid).m_21444_(arg_0)).toList();
        MutableInt count = new MutableInt();
        GraphCache.CacheRecord cache = GraphCache.getAndValidate(maid.m_9236_(), maid, this.iAutoCraftGuideGenerators);
        this.hasDoneTypes = new HashSet<ResourceLocation>();
        if (cache != null) {
            this.graph = cache.graph();
            this.recognizedTypePositions = cache.targets();
            this.hasDoneTypes.addAll(this.recognizedTypePositions.keySet());
            this.graph.invalidAllCraftWithType(INTERNAL_TYPE);
        } else {
            this.graph = this.getGraph(maid.m_9236_().m_9598_());
            this.recognizedTypePositions = new HashMap<ResourceLocation, List<BlockPos>>();
        }
        this.graph.setItems(this.inventory.stream().map(i -> i.itemStack).toList(), itemList);
        this.graph.setCurrentGeneratorType(INTERNAL_TYPE, true);
        ICachableGeneratorGraph iCachableGeneratorGraph = this.graph;
        if (iCachableGeneratorGraph instanceof IDebugContextSetter) {
            IDebugContextSetter i2 = (IDebugContextSetter)((Object)iCachableGeneratorGraph);
            i2.setDebugContext(this.debugContext);
        }
        hasExisted.forEach(craftGuideData -> this.graph.addRecipe(new ResourceLocation("_maid_storage_internal_existed", String.valueOf(count.incrementAndGet())), craftGuideData.getAllInputItemsWithOptional().stream().map(xva$0 -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{xva$0})).toList(), craftGuideData.getAllInputItemsWithOptional().stream().map(ItemStack::m_41613_).toList(), craftGuideData.getAllOutputItems(), t -> null));
    }

    public boolean processBlock() {
        this.updatePathfinding();
        int count = 0;
        if (this.craftGeneratorTypeIndex >= this.iAutoCraftGuideGenerators.size()) {
            return true;
        }
        IAutoCraftGuideGenerator generator = this.iAutoCraftGuideGenerators.get(this.craftGeneratorTypeIndex);
        if (!GeneratingConfig.isEnabled(generator.getType()) || this.hasDoneTypes.contains(generator.getType())) {
            ++this.craftGeneratorTypeIndex;
            return false;
        }
        if (!this.recognizedTypePositions.containsKey(generator.getType())) {
            this.recognizedTypePositions.put(generator.getType(), new ArrayList());
        }
        while (this.index < this.blockPosList.size()) {
            BlockPos next = this.blockPosList.get(this.index++);
            if (generator.isBlockValid(this.maid.m_9236_(), next)) {
                if (!generator.positionalAvailable((ServerLevel)this.maid.m_9236_(), this.maid, next, this.pathfindingBFS)) continue;
                if (generator.allowMultiPosition() || !Config.generateNearestOnly) {
                    ++count;
                    this.graph.setCurrentGeneratorType(generator);
                    this.debugContext.logNoLevel(CraftingDebugContext.TYPE.GENERATOR, "%s type generating at %s", generator, next);
                    generator.generate(this.inventory, this.maid.m_9236_(), next, this.graph, this.recognizedTypePositions);
                    this.recognizedTypePositions.get(generator.getType()).add(next);
                } else {
                    double distance = this.maid.m_20238_(next.m_252807_());
                    if (distance < this.currentMinDistance) {
                        this.currentMinDistance = distance;
                        this.minPos = next;
                    }
                }
            }
            if (count <= 10) continue;
            return false;
        }
        if (this.minPos != null) {
            this.graph.setCurrentGeneratorType(generator);
            this.debugContext.logNoLevel(CraftingDebugContext.TYPE.GENERATOR, "%s type generating at %s", generator, this.minPos);
            generator.generate(this.inventory, this.maid.m_9236_(), this.minPos, this.graph, this.recognizedTypePositions);
            this.recognizedTypePositions.get(generator.getType()).add(this.minPos);
        }
        this.minPos = null;
        this.currentMinDistance = Double.MAX_VALUE;
        this.index = 0;
        this.hasDoneTypes.add(generator.getType());
        ++this.craftGeneratorTypeIndex;
        return this.craftGeneratorTypeIndex >= this.iAutoCraftGuideGenerators.size();
    }

    public List<CraftGuideData> getCraftGuideData() {
        return this.graph.getCraftGuides();
    }

    public int getDone() {
        if (this.isProcessingBlocks) {
            return this.index + this.craftGeneratorTypeIndex * this.blockPosList.size();
        }
        return this.graph.getProcessedSteps();
    }

    public int getTotal() {
        if (this.isProcessingBlocks) {
            return this.blockPosList.size() * this.iAutoCraftGuideGenerators.size();
        }
        return this.graph.getPushedSteps();
    }

    public float getProgress() {
        return (float)this.getDone() / (float)this.getTotal();
    }

    public boolean process() {
        if (this.isProcessingBlocks) {
            if (this.processBlock()) {
                this.isProcessingBlocks = false;
            }
            return false;
        }
        return this.graph.process();
    }

    public void cache() {
        GraphCache.putCache(this.maid, this.recognizedTypePositions, this.graph);
    }

    @Override
    public void setDebugContext(CraftingDebugContext context) {
        this.debugContext = context;
        context.convey(this.graph);
    }
}

